/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.service;

import com.moscepa.dto.UniteEnseignementDto;
import com.moscepa.entity.Formation;
import com.moscepa.entity.UniteEnseignement;
import com.moscepa.entity.Utilisateur;
import com.moscepa.repository.ElementConstitutifRepository;
import com.moscepa.repository.FormationRepository;
import com.moscepa.repository.UniteEnseignementRepository;
import com.moscepa.repository.UtilisateurRepository;
import jakarta.persistence.EntityNotFoundException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UniteEnseignementService {
    @Autowired
    private UniteEnseignementRepository ueRepository;
    @Autowired
    private UtilisateurRepository utilisateurRepository;
    @Autowired
    private ElementConstitutifRepository elementConstitutifRepository;
    @Autowired
    private FormationRepository formationRepository;

    @Transactional(readOnly=true)
    public List<UniteEnseignementDto> findAll() {
        return this.ueRepository.findAll().stream().map(UniteEnseignementDto::new).collect(Collectors.toList());
    }

    @Transactional(readOnly=true)
    public Optional<UniteEnseignementDto> findById(Long id) {
        return this.ueRepository.findById((Object)id).map(UniteEnseignementDto::new);
    }

    @Transactional
    public UniteEnseignementDto save(UniteEnseignementDto ueDto) {
        this.ueRepository.findByCode(ueDto.getCode().trim()).ifPresent(existingUe -> {
            throw new IllegalStateException("Une unit\u00e9 d'enseignement avec le code '" + ueDto.getCode() + "' existe d\u00e9j\u00e0.");
        });
        UniteEnseignement ue = this.convertToEntity(ueDto);
        UniteEnseignement savedUe = (UniteEnseignement)this.ueRepository.save((Object)ue);
        return new UniteEnseignementDto(savedUe);
    }

    @Transactional
    public UniteEnseignementDto update(Long id, UniteEnseignementDto ueDto) {
        this.ueRepository.findByCode(ueDto.getCode().trim()).ifPresent(existingUe -> {
            if (!existingUe.getId().equals(id)) {
                throw new IllegalStateException("Une autre unit\u00e9 d'enseignement avec le code '" + ueDto.getCode() + "' existe d\u00e9j\u00e0.");
            }
        });
        UniteEnseignement existingUe2 = (UniteEnseignement)this.ueRepository.findById((Object)id).orElseThrow(() -> new EntityNotFoundException("Unit\u00e9 d'enseignement non trouv\u00e9e avec l'id: " + id));
        existingUe2.setNom(ueDto.getNom());
        existingUe2.setCode(ueDto.getCode());
        existingUe2.setDescription(ueDto.getDescription());
        existingUe2.setEcts(ueDto.getEcts());
        existingUe2.setSemestre(ueDto.getSemestre());
        existingUe2.setObjectifs(ueDto.getObjectifs());
        if (ueDto.getFormationId() == null) {
            throw new IllegalStateException("Formation obligatoire pour l'unit\u00e9 d'enseignement");
        }
        Formation formation = (Formation)this.formationRepository.findById((Object)ueDto.getFormationId()).orElseThrow(() -> new EntityNotFoundException("Formation non trouv\u00e9e avec l'id: " + ueDto.getFormationId()));
        existingUe2.setFormation(formation);
        if (ueDto.getResponsableId() != null) {
            Utilisateur responsable = (Utilisateur)this.utilisateurRepository.findById((Object)ueDto.getResponsableId()).orElseThrow(() -> new EntityNotFoundException("Responsable non trouv\u00e9 avec l'id: " + ueDto.getResponsableId()));
            existingUe2.setResponsable(responsable);
        } else {
            existingUe2.setResponsable(null);
        }
        if (ueDto.getElementConstitutifIds() != null) {
            List ecs = this.elementConstitutifRepository.findAllById((Iterable)ueDto.getElementConstitutifIds());
            existingUe2.setElementsConstitutifs(ecs);
        }
        UniteEnseignement updatedUe = (UniteEnseignement)this.ueRepository.save((Object)existingUe2);
        return new UniteEnseignementDto(updatedUe);
    }

    @Transactional
    public void deleteById(Long id) {
        if (!this.ueRepository.existsById((Object)id)) {
            throw new EntityNotFoundException("Impossible de supprimer, Unit\u00e9 d'enseignement non trouv\u00e9e avec l'id: " + id);
        }
        if (this.elementConstitutifRepository.countByUniteEnseignementId(id) > 0L) {
            throw new IllegalStateException("Cette unit\u00e9 ne peut pas \u00eatre supprim\u00e9e car des \u00e9l\u00e9ments constitutifs y sont rattach\u00e9s.");
        }
        this.ueRepository.deleteById((Object)id);
    }

    private UniteEnseignement convertToEntity(UniteEnseignementDto ueDto) {
        UniteEnseignement ue = new UniteEnseignement();
        ue.setId(ueDto.getId());
        ue.setNom(ueDto.getNom());
        ue.setCode(ueDto.getCode());
        ue.setDescription(ueDto.getDescription());
        ue.setEcts(ueDto.getEcts());
        ue.setSemestre(ueDto.getSemestre());
        ue.setObjectifs(ueDto.getObjectifs());
        ue.setVolumeHoraireCours(ueDto.getVolumeHoraireCours());
        ue.setVolumeHoraireTD(ueDto.getVolumeHoraireTD());
        ue.setVolumeHoraireTP(ueDto.getVolumeHoraireTP());
        if (ueDto.getFormationId() == null) {
            throw new IllegalStateException("Formation obligatoire pour l'unit\u00e9 d'enseignement");
        }
        Formation formation = (Formation)this.formationRepository.findById((Object)ueDto.getFormationId()).orElseThrow(() -> new EntityNotFoundException("Formation non trouv\u00e9e avec l'id: " + ueDto.getFormationId()));
        ue.setFormation(formation);
        if (ueDto.getResponsableId() != null) {
            Utilisateur responsable = (Utilisateur)this.utilisateurRepository.findById((Object)ueDto.getResponsableId()).orElseThrow(() -> new EntityNotFoundException("Responsable non trouv\u00e9 avec l'id: " + ueDto.getResponsableId()));
            ue.setResponsable(responsable);
        }
        if (ueDto.getElementConstitutifIds() != null) {
            List ecs = this.elementConstitutifRepository.findAllById((Iterable)ueDto.getElementConstitutifIds());
            ue.setElementsConstitutifs(ecs);
        }
        return ue;
    }
}

