/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.service;

import com.moscepa.dto.ChapitreSyllabusDto;
import com.moscepa.dto.MatiereSyllabusDto;
import com.moscepa.entity.Chapitre;
import com.moscepa.entity.ElementConstitutif;
import com.moscepa.entity.ResultatTest;
import com.moscepa.entity.Test;
import com.moscepa.repository.ElementConstitutifRepository;
import com.moscepa.repository.ResultatTestRepository;
import jakarta.persistence.EntityNotFoundException;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SyllabusService {
    private final ElementConstitutifRepository ecRepository;
    private final ResultatTestRepository resultatTestRepository;

    @Autowired
    public SyllabusService(ElementConstitutifRepository ecRepository, ResultatTestRepository resultatTestRepository) {
        this.ecRepository = ecRepository;
        this.resultatTestRepository = resultatTestRepository;
    }

    @Transactional(readOnly=true)
    public MatiereSyllabusDto getSyllabusPourEtudiant(Long ecId, Long utilisateurId) {
        ElementConstitutif ec = (ElementConstitutif)this.ecRepository.findById(ecId).orElseThrow(() -> new EntityNotFoundException("Mati\u00e8re non trouv\u00e9e avec l'ID: " + ecId));
        MatiereSyllabusDto matiereDto = new MatiereSyllabusDto();
        matiereDto.setId(ec.getId());
        matiereDto.setNom(ec.getNom());
        matiereDto.setCode(ec.getCode());
        matiereDto.setDescription(ec.getDescription());
        List chapitresDto = Optional.ofNullable(ec.getChapitres()).orElseGet(List::of).stream().map(chapitre -> this.convertToChapitreSyllabusDto(chapitre, utilisateurId)).sorted(Comparator.comparing(ChapitreSyllabusDto::getOrdre, Comparator.nullsLast(Comparator.naturalOrder()))).collect(Collectors.toList());
        matiereDto.setChapitres(chapitresDto);
        return matiereDto;
    }

    private ChapitreSyllabusDto convertToChapitreSyllabusDto(Chapitre chapitre, Long utilisateurId) {
        ChapitreSyllabusDto dto = new ChapitreSyllabusDto();
        dto.setId(chapitre.getId());
        dto.setNom(chapitre.getNom());
        dto.setOrdre(chapitre.getOrdre());
        List testsDuChapitre = chapitre.getTests();
        if (testsDuChapitre != null && !testsDuChapitre.isEmpty()) {
            Test premierTest = (Test)testsDuChapitre.get(0);
            Long testId = premierTest.getId();
            dto.setNomTest(premierTest.getTitre());
            Optional dernierResultatOpt = this.resultatTestRepository.findTopByEtudiantIdAndTestIdOrderByDateTestDesc(utilisateurId, testId);
            if (dernierResultatOpt.isPresent()) {
                ResultatTest dernierResultat = (ResultatTest)dernierResultatOpt.get();
                double score = dernierResultat.getScore();
                double total = dernierResultat.getScoreTotal();
                double pourcentage = total > 0.0 ? score / total * 100.0 : 0.0;
                dto.setResultatScore(Double.valueOf(pourcentage));
            } else {
                dto.setResultatScore(null);
            }
        } else {
            dto.setNomTest("Non d\u00e9fini");
            dto.setResultatScore(null);
        }
        dto.setCategorie("Concepts Cl\u00e9s");
        return dto;
    }
}

