/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.service;

import com.moscepa.dto.SectionCreateDto;
import com.moscepa.dto.SectionDto;
import com.moscepa.dto.SectionUpdateRequest;
import com.moscepa.entity.Chapitre;
import com.moscepa.entity.Section;
import com.moscepa.repository.ChapitreRepository;
import com.moscepa.repository.SectionRepository;
import jakarta.persistence.EntityNotFoundException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SectionService {
    @Autowired
    private SectionRepository sectionRepository;
    @Autowired
    private ChapitreRepository chapitreRepository;

    private SectionDto convertToDto(Section section) {
        return new SectionDto(section);
    }

    @Transactional
    public SectionDto createSection(Long chapitreId, SectionCreateDto dto) {
        Chapitre chapitre = (Chapitre)this.chapitreRepository.findById((Object)chapitreId).orElseThrow(() -> new EntityNotFoundException("Chapitre non trouv\u00e9 avec l'ID : " + chapitreId));
        int nouvelOrdre = chapitre.getSections().size() + 1;
        Section nouvelleSection = new Section();
        nouvelleSection.setTitre(dto.getTitre());
        nouvelleSection.setContenu(dto.getContenu() != null ? dto.getContenu() : "");
        nouvelleSection.setTypeSection(dto.getTypeSection());
        nouvelleSection.setOrdre(Integer.valueOf(nouvelOrdre));
        nouvelleSection.setChapitre(chapitre);
        Section sectionSauvegardee = (Section)this.sectionRepository.save((Object)nouvelleSection);
        return this.convertToDto(sectionSauvegardee);
    }

    @Transactional(readOnly=true)
    public List<SectionDto> getAllSections() {
        return this.sectionRepository.findAll().stream().map(arg_0 -> this.convertToDto(arg_0)).collect(Collectors.toList());
    }

    @Transactional(readOnly=true)
    public Optional<SectionDto> getSectionById(Long id) {
        return this.sectionRepository.findById((Object)id).map(arg_0 -> this.convertToDto(arg_0));
    }

    @Transactional
    public SectionDto updateSectionContent(Long id, SectionUpdateRequest updateRequest) {
        Section section = (Section)this.sectionRepository.findById((Object)id).orElseThrow(() -> new EntityNotFoundException("Section non trouv\u00e9e avec l'ID : " + id));
        section.setTitre(updateRequest.titre());
        section.setContenu(updateRequest.contenu());
        Section updatedSection = (Section)this.sectionRepository.save((Object)section);
        return this.convertToDto(updatedSection);
    }

    @Transactional
    public void deleteSection(Long id) {
        if (!this.sectionRepository.existsById((Object)id)) {
            throw new EntityNotFoundException("Section non trouv\u00e9e avec l'ID : " + id);
        }
        this.sectionRepository.deleteById((Object)id);
    }
}

