/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.service;

import com.moscepa.dto.GenerationRequestDto;
import com.moscepa.dto.QuestionDto;
import com.moscepa.dto.QuestionnaireDetailDto;
import com.moscepa.dto.ReponsePourQuestionDto;
import com.moscepa.entity.Chapitre;
import com.moscepa.entity.Question;
import com.moscepa.entity.Questionnaire;
import com.moscepa.entity.Reponse;
import com.moscepa.entity.TypeQuestionnaire;
import com.moscepa.repository.ChapitreRepository;
import com.moscepa.repository.QuestionRepository;
import com.moscepa.repository.QuestionnaireRepository;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class QuestionnaireService {
    private static final Logger logger = LoggerFactory.getLogger(QuestionnaireService.class);
    @Autowired
    private QuestionnaireRepository questionnaireRepository;
    @Autowired
    private ChapitreRepository chapitreRepository;
    @Autowired
    private QuestionRepository questionRepository;

    @Transactional(readOnly=true)
    public List<QuestionnaireDetailDto> getAllQuestionnairesDetail() {
        logger.info("Service: R\u00e9cup\u00e9ration de tous les questionnaires");
        return this.questionnaireRepository.findAll().stream().map(arg_0 -> this.convertToDtoWithQuestions(arg_0)).collect(Collectors.toList());
    }

    @Transactional(readOnly=true)
    public QuestionnaireDetailDto getQuestionnaireDetailById(Long id) {
        logger.info("Service: R\u00e9cup\u00e9ration du questionnaire ID: {}", (Object)id);
        Questionnaire questionnaire = (Questionnaire)this.questionnaireRepository.findByIdWithQuestions(id).orElseThrow(() -> {
            logger.error("Questionnaire non trouv\u00e9 avec ID: {}", (Object)id);
            return new RuntimeException("Questionnaire non trouv\u00e9 avec l'ID: " + id);
        });
        logger.debug("Questionnaire trouv\u00e9: {}", (Object)questionnaire.getTitre());
        logger.debug("Nombre de questions: {}", (Object)(questionnaire.getQuestions() != null ? questionnaire.getQuestions().size() : 0));
        return new QuestionnaireDetailDto(questionnaire);
    }

    @Transactional
    public QuestionnaireDetailDto createQuestionnaire(QuestionnaireDetailDto dto) {
        QuestionnaireDetailDto resultDto;
        logger.info("=== \ud83d\ude80 D\u00c9BUT CR\u00c9ATION QUESTIONNAIRE ===");
        logger.info("\ud83d\udccb Donn\u00e9es re\u00e7ues:");
        logger.info("  - Titre: {}", (Object)dto.getTitre());
        logger.info("  - ChapitreId: {}", (Object)dto.getChapitreId());
        logger.info("  - Dur\u00e9e: {}", (Object)dto.getDuree());
        logger.info("  - Description: {}", (Object)dto.getDescription());
        logger.info("  - Nombre de questions: {}", (Object)(dto.getQuestions() != null ? dto.getQuestions().size() : 0));
        if (dto.getTitre() == null || dto.getTitre().trim().isEmpty()) {
            logger.error("\u274c Titre manquant ou vide");
            throw new IllegalArgumentException("Le titre est obligatoire");
        }
        if (dto.getChapitreId() == null) {
            logger.error("\u274c chapitreId est null dans le DTO");
            throw new IllegalArgumentException("Le chapitre est obligatoire");
        }
        Chapitre chapitre = (Chapitre)this.chapitreRepository.findById((Object)dto.getChapitreId()).orElseThrow(() -> {
            logger.error("\u274c Chapitre non trouv\u00e9 avec ID: {}", (Object)dto.getChapitreId());
            return new IllegalArgumentException("Chapitre non trouv\u00e9 avec ID: " + dto.getChapitreId());
        });
        logger.info("\u2705 Chapitre trouv\u00e9: {} (ID: {})", (Object)chapitre.getNom(), (Object)chapitre.getId());
        if (dto.getType() == null) {
            logger.error("\u274c Type de questionnaire manquant dans le DTO");
            throw new IllegalArgumentException("Le type de questionnaire (EXERCICE, TEST, QUIZ) est obligatoire");
        }
        Questionnaire questionnaire = new Questionnaire();
        questionnaire.setTitre(dto.getTitre());
        questionnaire.setDescription(dto.getDescription());
        questionnaire.setDuree(dto.getDuree());
        questionnaire.setChapitre(chapitre);
        questionnaire.setType(dto.getType());
        if (questionnaire.getAuteur() == null) {
            questionnaire.setAuteur("Syst\u00e8me");
        }
        if (dto.getQuestions() != null && !dto.getQuestions().isEmpty()) {
            logger.info("\ud83d\udcdd Traitement de {} questions:", (Object)dto.getQuestions().size());
            int questionIndex = 0;
            for (QuestionDto questionDto : dto.getQuestions()) {
                logger.info("  \ud83d\udccb Question {}/{}: '{}' (Type: {})", new Object[]{++questionIndex, dto.getQuestions().size(), questionDto.getEnonce(), questionDto.getType()});
                Question question = new Question();
                question.setEnonce(questionDto.getEnonce());
                question.setTypeQuestion(questionDto.getType());
                question.setPoints(questionDto.getPoints());
                question.setQuestionnaire(questionnaire);
                if (questionDto.getReponses() != null && !questionDto.getReponses().isEmpty()) {
                    logger.info("    \ud83d\udccb {} r\u00e9ponse(s) pour cette question", (Object)questionDto.getReponses().size());
                    int reponseIndex = 0;
                    int correctesCount = 0;
                    for (ReponsePourQuestionDto reponseDto : questionDto.getReponses()) {
                        ++reponseIndex;
                        Reponse reponse = new Reponse();
                        reponse.setTexte(reponseDto.getTexte());
                        reponse.setCorrecte(reponseDto.isCorrecte());
                        reponse.setQuestion(question);
                        if (reponseDto.isCorrecte()) {
                            ++correctesCount;
                        }
                        question.getReponses().add(reponse);
                        logger.debug("      - R\u00e9ponse {}: '{}' (Correcte: {})", new Object[]{reponseIndex, reponseDto.getTexte(), reponseDto.isCorrecte()});
                    }
                    logger.info("    \u2705 {} r\u00e9ponse(s) correcte(s) sur {}", (Object)correctesCount, (Object)reponseIndex);
                } else {
                    logger.info("    \u26a0\ufe0f Aucune r\u00e9ponse pour cette question");
                }
                questionnaire.getQuestions().add(question);
                logger.info("    \u2795 Question ajout\u00e9e au questionnaire");
            }
            logger.info("\u2705 Total: {} questions trait\u00e9es", (Object)dto.getQuestions().size());
        } else {
            logger.warn("\u26a0\ufe0f Aucune question fournie dans le DTO");
        }
        logger.info("\ud83d\udcbe Sauvegarde du questionnaire en base...");
        Questionnaire saved = (Questionnaire)this.questionnaireRepository.save((Object)questionnaire);
        logger.info("=== \u2705 QUESTIONNAIRE CR\u00c9\u00c9 AVEC SUCC\u00c8S ===");
        logger.info("\ud83d\udccc ID: {}", (Object)saved.getId());
        logger.info("\ud83d\udccc Titre: {}", (Object)saved.getTitre());
        logger.info("\ud83d\udccc Chapitre: {} (ID: {})", (Object)saved.getChapitre().getNom(), (Object)saved.getChapitre().getId());
        logger.info("\ud83d\udccc Questions sauvegard\u00e9es: {}", (Object)(saved.getQuestions() != null ? saved.getQuestions().size() : 0));
        if (saved.getQuestions() != null) {
            logger.info("\ud83d\udcca D\u00e9tail des questions sauvegard\u00e9es:");
            saved.getQuestions().forEach(q -> logger.info("  - Question ID {}: '{}' ({} r\u00e9ponse(s))", new Object[]{q.getId(), q.getEnonce(), q.getReponses() != null ? q.getReponses().size() : 0}));
        }
        logger.info("\ud83d\udce4 Retour du DTO avec {} questions", (Object)((resultDto = new QuestionnaireDetailDto(saved)).getQuestions() != null ? resultDto.getQuestions().size() : 0));
        return resultDto;
    }

    @Transactional
    public QuestionnaireDetailDto genererQuestionnaireDepuisBanque(GenerationRequestDto generationRequest) {
        String niveau;
        Long idChoisi = generationRequest.getChapitreId() != null ? generationRequest.getChapitreId() : 1L;
        List questionsDisponibles = this.questionRepository.findByChapitreIdAndDifficulteNative(idChoisi, niveau = generationRequest.getNiveau());
        if (questionsDisponibles.isEmpty()) {
            throw new IllegalStateException("Aucune question trouv\u00e9e pour le Chapitre ID " + idChoisi);
        }
        Questionnaire nouveauQuestionnaire = new Questionnaire();
        nouveauQuestionnaire.setTitre("G\u00e9n\u00e9ration Auto : " + niveau);
        nouveauQuestionnaire.setType(TypeQuestionnaire.TEST);
        nouveauQuestionnaire.setAuteur("Syst\u00e8me");
        Chapitre chapitreChoisi = (Chapitre)this.chapitreRepository.findById((Object)idChoisi).orElseThrow(() -> new IllegalStateException("Chapitre non trouv\u00e9"));
        nouveauQuestionnaire.setChapitre(chapitreChoisi);
        Collections.shuffle(questionsDisponibles);
        int nbToSelect = Math.min(generationRequest.getNombreQuestions(), questionsDisponibles.size());
        for (int i = 0; i < nbToSelect; ++i) {
            Question source = (Question)questionsDisponibles.get(i);
            Question nouvelleQ = new Question();
            nouvelleQ.setEnonce(source.getEnonce());
            nouvelleQ.setPoints(source.getPoints());
            nouvelleQ.setQuestionnaire(nouveauQuestionnaire);
            nouveauQuestionnaire.getQuestions().add(nouvelleQ);
        }
        Questionnaire saved = (Questionnaire)this.questionnaireRepository.save((Object)nouveauQuestionnaire);
        return new QuestionnaireDetailDto(saved);
    }

    @Transactional
    public QuestionnaireDetailDto updateQuestionnaire(Long id, QuestionnaireDetailDto dto) {
        logger.info("Service: Mise \u00e0 jour du questionnaire ID: {}", (Object)id);
        Questionnaire existing = (Questionnaire)this.questionnaireRepository.findById((Object)id).orElseThrow(() -> new RuntimeException("Questionnaire non trouv\u00e9 avec l'ID: " + id));
        existing.setTitre(dto.getTitre());
        existing.setDescription(dto.getDescription());
        existing.setDuree(dto.getDuree());
        existing.setType(dto.getType());
        if (dto.getChapitreId() != null) {
            Chapitre chapitre = (Chapitre)this.chapitreRepository.findById((Object)dto.getChapitreId()).orElseThrow(() -> new IllegalArgumentException("Chapitre non trouv\u00e9"));
            existing.setChapitre(chapitre);
        }
        existing.getQuestions().clear();
        if (dto.getQuestions() != null && !dto.getQuestions().isEmpty()) {
            for (QuestionDto qDto : dto.getQuestions()) {
                Question question = new Question();
                question.setEnonce(qDto.getEnonce());
                question.setTypeQuestion(qDto.getType());
                question.setPoints(qDto.getPoints());
                question.setQuestionnaire(existing);
                if (qDto.getReponses() != null) {
                    for (ReponsePourQuestionDto rDto : qDto.getReponses()) {
                        Reponse reponse = new Reponse();
                        reponse.setTexte(rDto.getTexte());
                        reponse.setCorrecte(rDto.isCorrecte());
                        reponse.setQuestion(question);
                        question.getReponses().add(reponse);
                    }
                }
                existing.getQuestions().add(question);
            }
        }
        Questionnaire saved = (Questionnaire)this.questionnaireRepository.save((Object)existing);
        logger.info("\u2705 Questionnaire ID {} mis \u00e0 jour avec son type et ses questions", (Object)id);
        return new QuestionnaireDetailDto(saved);
    }

    @Transactional
    public boolean deleteQuestionnaire(Long id) {
        logger.info("Service: Suppression du questionnaire ID: {}", (Object)id);
        if (!this.questionnaireRepository.existsById((Object)id)) {
            logger.warn("Tentative de suppression d'un questionnaire inexistant ID: {}", (Object)id);
            return false;
        }
        this.questionnaireRepository.deleteById((Object)id);
        logger.info("\u2705 Questionnaire ID {} supprim\u00e9", (Object)id);
        return true;
    }

    private QuestionnaireDetailDto convertToDtoWithQuestions(Questionnaire questionnaire) {
        return this.questionnaireRepository.findByIdWithQuestions(questionnaire.getId()).map(QuestionnaireDetailDto::new).orElseGet(() -> {
            logger.warn("Impossible de charger les questions pour le questionnaire ID: {}", (Object)questionnaire.getId());
            return new QuestionnaireDetailDto(questionnaire);
        });
    }

    public void debugDTO(QuestionnaireDetailDto dto) {
        logger.info("=== \ud83d\udd0d DEBUG DTO ===");
        logger.info("Titre: {}", (Object)dto.getTitre());
        logger.info("ChapitreId: {}", (Object)dto.getChapitreId());
        logger.info("Nombre de questions: {}", dto.getQuestions() != null ? Integer.valueOf(dto.getQuestions().size()) : "null");
        if (dto.getQuestions() != null) {
            for (int i = 0; i < dto.getQuestions().size(); ++i) {
                QuestionDto q = (QuestionDto)dto.getQuestions().get(i);
                logger.info("  Question {}: {}", (Object)(i + 1), (Object)q.getEnonce());
                logger.info("    Type: {}, Points: {}", (Object)q.getType(), (Object)q.getPoints());
                logger.info("    R\u00e9ponses: {}", (Object)(q.getReponses() != null ? q.getReponses().size() : 0));
            }
        }
        logger.info("=== FIN DEBUG ===");
    }

    @Transactional(readOnly=true)
    public List<QuestionnaireDetailDto> getQuestionnairesParChapitre(Long chapitreId) {
        logger.info("Service: R\u00e9cup\u00e9ration des questionnaires pour le chapitre ID: {}", (Object)chapitreId);
        List questionnaires = this.questionnaireRepository.findByChapitreId(chapitreId);
        return questionnaires.stream().map(arg_0 -> this.convertToDtoWithQuestions(arg_0)).collect(Collectors.toList());
    }

    @Transactional(readOnly=true)
    public List<QuestionnaireDetailDto> getExercicesOnly() {
        logger.info("Service: R\u00e9cup\u00e9ration de tous les questionnaires de type EXERCICE");
        return this.questionnaireRepository.findByType(TypeQuestionnaire.EXERCICE).stream().map(arg_0 -> this.convertToDtoWithQuestions(arg_0)).collect(Collectors.toList());
    }
}

