/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.service;

import com.moscepa.dto.ChapitreProgressDto;
import com.moscepa.dto.ChapitreProgressFrontDto;
import com.moscepa.dto.MatiereStatutDto;
import com.moscepa.entity.Chapitre;
import com.moscepa.entity.ResultatTest;
import com.moscepa.repository.ElementConstitutifRepository;
import com.moscepa.repository.ResultatTestRepository;
import com.moscepa.service.FrontendMapperService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProgressionService {
    private final ElementConstitutifRepository elementConstitutifRepository;
    private final ResultatTestRepository resultatTestRepository;
    private final FrontendMapperService mapperService;

    public ProgressionService(ElementConstitutifRepository elementConstitutifRepository, ResultatTestRepository resultatTestRepository, FrontendMapperService mapperService) {
        this.elementConstitutifRepository = elementConstitutifRepository;
        this.resultatTestRepository = resultatTestRepository;
        this.mapperService = mapperService;
    }

    @Transactional(readOnly=true)
    public List<MatiereStatutDto> findMatieresByEtudiant(Long etudiantId) {
        List matieres = this.elementConstitutifRepository.findMatieresByEtudiantIdSqlNatif(etudiantId);
        return matieres.stream().map(matiere -> {
            double moyenne;
            List resultats = this.resultatTestRepository.findByEtudiantIdAndMatiereId(etudiantId, matiere.getId());
            double totalScore = resultats.stream().mapToDouble(ResultatTest::getScore).sum();
            int nbTests = resultats.size();
            double d = moyenne = nbTests > 0 ? totalScore / (double)nbTests : 0.0;
            String statut = moyenne <= 33.0 ? "D\u00e9butant" : (moyenne <= 66.0 ? "Interm\u00e9diaire" : "Ma\u00eetrise");
            return new MatiereStatutDto(matiere.getId(), matiere.getNom(), moyenne, matiere.getCode(), matiere.getCredit(), statut);
        }).collect(Collectors.toList());
    }

    @Transactional(readOnly=true)
    public List<ChapitreProgressDto> findChapitresProgressByStudent(Long etudiantId, String parcoursType) {
        List resultats = this.resultatTestRepository.findByEtudiantIdWithDetails(etudiantId);
        HashMap<Chapitre, List> resultatsParChapitre = new HashMap<Chapitre, List>();
        for (ResultatTest resultat : resultats) {
            if (resultat.getTest() == null || resultat.getTest().getChapitre() == null) continue;
            Chapitre chapitre = resultat.getTest().getChapitre();
            if (parcoursType != null && !parcoursType.isEmpty()) {
                if (chapitre.getParcoursType() == null || !chapitre.getParcoursType().equals(parcoursType)) continue;
                resultatsParChapitre.computeIfAbsent(chapitre, k -> new ArrayList()).add(resultat);
                continue;
            }
            resultatsParChapitre.computeIfAbsent(chapitre, k -> new ArrayList()).add(resultat);
        }
        ArrayList<ChapitreProgressDto> chapitresProgress = new ArrayList<ChapitreProgressDto>();
        for (Map.Entry entry : resultatsParChapitre.entrySet()) {
            Chapitre chapitre = (Chapitre)entry.getKey();
            List resultatsChapitre = (List)entry.getValue();
            double moyenne = resultatsChapitre.stream().mapToDouble(rt -> {
                if (rt.getScoreTotal() != null && rt.getScoreTotal() > 0.0) {
                    return rt.getScore() / rt.getScoreTotal() * 100.0;
                }
                return rt.getScore();
            }).average().orElse(0.0);
            LocalDateTime dateDernierTest = resultatsChapitre.stream().map(ResultatTest::getDateTest).max(LocalDateTime::compareTo).orElse(null);
            String typeParcours = chapitre.getParcoursType() != null ? chapitre.getParcoursType() : (parcoursType != null ? parcoursType : "RECOMMANDE");
            ChapitreProgressDto dto = new ChapitreProgressDto(chapitre.getId(), chapitre.getNom(), chapitre.getOrdre(), Double.valueOf(moyenne), typeParcours, dateDernierTest, resultatsChapitre.size());
            chapitresProgress.add(dto);
        }
        chapitresProgress.sort(Comparator.comparing(ChapitreProgressDto::getOrdre));
        return chapitresProgress;
    }

    public List<ChapitreProgressFrontDto> findChapitresProgressForFrontend(Long etudiantId, String parcoursType) {
        List backendList = this.findChapitresProgressByStudent(etudiantId, parcoursType);
        return this.mapperService.toChapitreFrontDtoList(backendList);
    }

    @Transactional(readOnly=true)
    public Map<String, List<ChapitreProgressDto>> findChapitresGroupedByMatiere(Long etudiantId, String parcoursType) {
        List chapitres = this.findChapitresProgressByStudent(etudiantId, parcoursType);
        HashMap<String, List<ChapitreProgressDto>> groupedByMatiere = new HashMap<String, List<ChapitreProgressDto>>();
        for (ChapitreProgressDto chapitre : chapitres) {
            String matiereNom = "Mati\u00e8re inconnue";
            groupedByMatiere.computeIfAbsent(matiereNom, k -> new ArrayList()).add(chapitre);
        }
        return groupedByMatiere;
    }

    public Map<String, List<ChapitreProgressFrontDto>> findChapitresGroupedForFrontend(Long etudiantId, String parcoursType) {
        Map backendMap = this.findChapitresGroupedByMatiere(etudiantId, parcoursType);
        HashMap<String, List<ChapitreProgressFrontDto>> frontMap = new HashMap<String, List<ChapitreProgressFrontDto>>();
        backendMap.forEach((matiere, chapitres) -> {
            List frontChapitres = this.mapperService.toChapitreFrontDtoList(chapitres);
            frontMap.put((String)matiere, frontChapitres);
        });
        return frontMap;
    }
}

