/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.service;

import com.moscepa.entity.RolePermission;
import com.moscepa.repository.RolePermissionRepository;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PermissionService {
    @Autowired
    private RolePermissionRepository permissionRepository;

    @Transactional(readOnly=true)
    public Map<String, Set<String>> getAllPermissionsByRole() {
        return this.permissionRepository.findAll().stream().collect(Collectors.toMap(RolePermission::getRoleName, RolePermission::getAllowedFeatures));
    }

    @Transactional
    public void updatePermissionsForRole(String roleName, Set<String> allowedFeatures) {
        RolePermission permissions = this.permissionRepository.findById((Object)roleName).orElse(new RolePermission());
        permissions.setRoleName(roleName);
        permissions.setAllowedFeatures(allowedFeatures);
        this.permissionRepository.save((Object)permissions);
    }
}

