/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.service;

import com.moscepa.dto.InscriptionRequestDto;
import com.moscepa.dto.InscriptionResponseDto;
import com.moscepa.dto.InscriptionValidationRequest;
import com.moscepa.entity.ElementConstitutif;
import com.moscepa.entity.Inscription;
import com.moscepa.entity.Utilisateur;
import com.moscepa.repository.ElementConstitutifRepository;
import com.moscepa.repository.InscriptionRepository;
import com.moscepa.repository.UtilisateurRepository;
import jakarta.persistence.EntityNotFoundException;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InscriptionService {
    private final InscriptionRepository inscriptionRepository;
    private final UtilisateurRepository utilisateurRepository;
    private final ElementConstitutifRepository ecRepository;

    public InscriptionService(InscriptionRepository inscriptionRepository, UtilisateurRepository utilisateurRepository, ElementConstitutifRepository ecRepository) {
        this.inscriptionRepository = inscriptionRepository;
        this.utilisateurRepository = utilisateurRepository;
        this.ecRepository = ecRepository;
    }

    public List<InscriptionResponseDto> getMesInscriptionsValidees(Long etudiantId) {
        return this.inscriptionRepository.findByEtudiantIdAndStatut(etudiantId, "VALIDE").stream().map(arg_0 -> this.mapToDto(arg_0)).toList();
    }

    @Transactional
    public InscriptionResponseDto inscrireEtudiant(InscriptionRequestDto request) {
        Utilisateur etudiant = (Utilisateur)this.utilisateurRepository.findById((Object)request.getEtudiantId()).orElseThrow(() -> new EntityNotFoundException("\u00c9tudiant non trouv\u00e9"));
        ElementConstitutif matiere = (ElementConstitutif)this.ecRepository.findById(request.getEcId()).orElseThrow(() -> new EntityNotFoundException("Mati\u00e8re non trouv\u00e9e"));
        if (this.inscriptionRepository.existsByEtudiantIdAndMatiereId(etudiant.getId(), matiere.getId())) {
            throw new IllegalStateException("D\u00e9j\u00e0 inscrit \u00e0 cette mati\u00e8re.");
        }
        Inscription inscription = new Inscription();
        inscription.setEtudiant(etudiant);
        inscription.setMatiere(matiere);
        return this.mapToDto((Inscription)this.inscriptionRepository.save((Object)inscription));
    }

    @Transactional
    public InscriptionResponseDto validerInscription(InscriptionValidationRequest request) {
        Inscription ins = (Inscription)this.inscriptionRepository.findById((Object)request.getInscriptionId()).orElseThrow(() -> new EntityNotFoundException("Inscription non trouv\u00e9e"));
        if (!"EN_ATTENTE".equals(ins.getStatut())) {
            throw new IllegalStateException("Inscription d\u00e9j\u00e0 trait\u00e9e.");
        }
        ins.setStatut(request.getStatut());
        ins.setDateValidation(LocalDateTime.now());
        return this.mapToDto((Inscription)this.inscriptionRepository.save((Object)ins));
    }

    public List<InscriptionResponseDto> getInscriptionsEnAttente() {
        return this.inscriptionRepository.findByStatut("EN_ATTENTE").stream().map(arg_0 -> this.mapToDto(arg_0)).toList();
    }

    private InscriptionResponseDto mapToDto(Inscription ins) {
        InscriptionResponseDto dto = new InscriptionResponseDto();
        dto.setId(ins.getId());
        dto.setStatut(ins.getStatut());
        dto.setActif(ins.isActif());
        dto.setEtudiantId(ins.getEtudiant().getId());
        dto.setEtudiantNomComplet(ins.getEtudiant().getPrenom() + " " + ins.getEtudiant().getNom());
        dto.setEcId(ins.getMatiere().getId());
        dto.setEcNom(ins.getMatiere().getNom());
        dto.setDateInscription(ins.getDateInscription().toString());
        return dto;
    }
}

