/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.service;

import com.moscepa.dto.FormationCreationDto;
import com.moscepa.dto.FormationDetailDto;
import com.moscepa.entity.CompetenceDetail;
import com.moscepa.entity.Departement;
import com.moscepa.entity.Etablissement;
import com.moscepa.entity.Formation;
import com.moscepa.entity.NiveauAcquisition;
import com.moscepa.entity.Uefr;
import com.moscepa.entity.UniteEnseignement;
import com.moscepa.entity.Utilisateur;
import com.moscepa.repository.DepartementRepository;
import com.moscepa.repository.ElementConstitutifRepository;
import com.moscepa.repository.EtablissementRepository;
import com.moscepa.repository.FormationRepository;
import com.moscepa.repository.UefrRepository;
import com.moscepa.repository.UtilisateurRepository;
import com.moscepa.security.UserPrincipal;
import jakarta.persistence.EntityNotFoundException;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class FormationService {
    private final FormationRepository formationRepository;
    private final UtilisateurRepository utilisateurRepository;
    private final ElementConstitutifRepository elementConstitutifRepository;
    private final EtablissementRepository etablissementRepository;
    private final UefrRepository uefrRepository;
    private final DepartementRepository departementRepository;

    public FormationService(FormationRepository formationRepository, UtilisateurRepository utilisateurRepository, ElementConstitutifRepository elementConstitutifRepository, EtablissementRepository etablissementRepository, UefrRepository uefrRepository, DepartementRepository departementRepository) {
        this.formationRepository = formationRepository;
        this.utilisateurRepository = utilisateurRepository;
        this.elementConstitutifRepository = elementConstitutifRepository;
        this.etablissementRepository = etablissementRepository;
        this.uefrRepository = uefrRepository;
        this.departementRepository = departementRepository;
    }

    @Transactional
    public FormationDetailDto creerFormation(FormationCreationDto dto) {
        this.formationRepository.findByCode(dto.getCode()).ifPresent(f -> {
            throw new IllegalArgumentException("Code d\u00e9j\u00e0 utilis\u00e9.");
        });
        this.formationRepository.findByNom(dto.getNom()).ifPresent(f -> {
            throw new IllegalArgumentException("Nom d\u00e9j\u00e0 utilis\u00e9.");
        });
        UserPrincipal userPrincipal = (UserPrincipal)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        Utilisateur createur = (Utilisateur)this.utilisateurRepository.findById((Object)userPrincipal.getId()).orElseThrow(() -> new EntityNotFoundException("Cr\u00e9ateur non trouv\u00e9."));
        Formation formation = new Formation();
        formation.setNom(dto.getNom());
        formation.setCode(dto.getCode());
        formation.setDescription(dto.getDescription());
        formation.setStatut(dto.getStatut());
        formation.setNiveauEtude(dto.getNiveauEtude());
        formation.setDuree(dto.getDuree());
        formation.setCreateur(createur);
        if (dto.getResponsableId() != null) {
            Utilisateur responsable = (Utilisateur)this.utilisateurRepository.findById((Object)dto.getResponsableId()).orElseThrow(() -> new EntityNotFoundException("Responsable p\u00e9dagogique non trouv\u00e9."));
            formation.setResponsablePedagogique(responsable);
        }
        formation.setObjectifs(dto.getObjectifs());
        formation.setPrerequis(dto.getPrerequis());
        formation.setDebouches(dto.getDebouches());
        formation.setEvaluationModalites(dto.getEvaluationModalites());
        formation.setModaliteEnseignement(dto.getModaliteEnseignement());
        formation.setLieu(dto.getLieu());
        formation.setDateDebut(dto.getDateDebut() != null ? dto.getDateDebut().atStartOfDay() : null);
        formation.setDateFin(dto.getDateFin() != null ? dto.getDateFin().atStartOfDay() : null);
        formation.setCapacite(dto.getCapacite());
        formation.setTarif(dto.getTarif());
        formation.setCertificationProfessionnelle(dto.getCertificationProfessionnelle());
        if (dto.getEtablissementId() != null) {
            Etablissement etablissement = (Etablissement)this.etablissementRepository.findById((Object)dto.getEtablissementId()).orElseThrow(() -> new EntityNotFoundException("\u00c9tablissement non trouv\u00e9 avec l'ID: " + dto.getEtablissementId()));
            formation.setEtablissement(etablissement);
        }
        if (dto.getUefrId() != null) {
            Uefr uefr = (Uefr)this.uefrRepository.findById((Object)dto.getUefrId()).orElseThrow(() -> new EntityNotFoundException("UFR non trouv\u00e9e avec l'ID: " + dto.getUefrId()));
            formation.setUefr(uefr);
        }
        if (dto.getDepartementId() != null) {
            Departement departement = (Departement)this.departementRepository.findById((Object)dto.getDepartementId()).orElseThrow(() -> new EntityNotFoundException("D\u00e9partement non trouv\u00e9 avec l'ID: " + dto.getDepartementId()));
            formation.setDepartement(departement);
        }
        Formation savedFormation = (Formation)this.formationRepository.save((Object)formation);
        if (dto.getCompetences() != null) {
            dto.getCompetences().forEach(compDto -> {
                CompetenceDetail competence = new CompetenceDetail();
                competence.setLibelle(compDto.getLibelle());
                competence.setNiveauAcquisition(NiveauAcquisition.valueOf((String)compDto.getNiveauAcquisition()));
                competence.setIndicateursEvaluation(compDto.getIndicateursEvaluation());
                competence.setFormation(savedFormation);
                savedFormation.getCompetences().add(competence);
            });
        }
        if (dto.getUnitesEnseignement() != null) {
            dto.getUnitesEnseignement().forEach(ueDto -> {
                UniteEnseignement ue = new UniteEnseignement();
                ue.setNom(ueDto.getNom());
                ue.setCode(ueDto.getCode());
                ue.setDescription(ueDto.getDescription());
                ue.setEcts(ueDto.getEcts());
                ue.setSemestre(ueDto.getSemestre());
                ue.setObjectifs(ueDto.getObjectifs());
                ue.setVolumeHoraireCours(ueDto.getVolumeHoraireCours());
                ue.setVolumeHoraireTD(ueDto.getVolumeHoraireTD());
                ue.setVolumeHoraireTP(ueDto.getVolumeHoraireTP());
                ue.setFormation(savedFormation);
                if (ueDto.getResponsableId() != null) {
                    Utilisateur respUe = (Utilisateur)this.utilisateurRepository.findById((Object)ueDto.getResponsableId()).orElseThrow(() -> new EntityNotFoundException("Responsable UE non trouv\u00e9."));
                    ue.setResponsable(respUe);
                }
                if (ueDto.getElementConstitutifIds() != null && !ueDto.getElementConstitutifIds().isEmpty()) {
                    List elements = this.elementConstitutifRepository.findAllById((Iterable)ueDto.getElementConstitutifIds());
                    ue.setElementsConstitutifs(elements);
                }
                savedFormation.getUnitesEnseignement().add(ue);
            });
        }
        return new FormationDetailDto((Formation)this.formationRepository.save((Object)savedFormation));
    }

    public List<FormationDetailDto> getFormationsByCreateurId(Long createurId) {
        return this.formationRepository.findAllByCreateurId(createurId).stream().map(FormationDetailDto::new).collect(Collectors.toList());
    }

    public List<FormationDetailDto> getAllFormations() {
        return this.formationRepository.findAll().stream().map(FormationDetailDto::new).collect(Collectors.toList());
    }

    public FormationDetailDto getFormationById(Long id) {
        Formation formation = (Formation)this.formationRepository.findById((Object)id).orElseThrow(() -> new EntityNotFoundException("Formation non trouv\u00e9e avec l'ID: " + id));
        return new FormationDetailDto(formation);
    }

    @Transactional
    public FormationDetailDto modifierFormation(Long id, FormationCreationDto dto) {
        Formation formation = (Formation)this.formationRepository.findById((Object)id).orElseThrow(() -> new EntityNotFoundException("Formation non trouv\u00e9e."));
        if (!formation.getCode().equals(dto.getCode())) {
            this.formationRepository.findByCode(dto.getCode()).ifPresent(f -> {
                throw new IllegalArgumentException("Code d\u00e9j\u00e0 utilis\u00e9.");
            });
        }
        if (!formation.getNom().equals(dto.getNom())) {
            this.formationRepository.findByNom(dto.getNom()).ifPresent(f -> {
                throw new IllegalArgumentException("Nom d\u00e9j\u00e0 utilis\u00e9.");
            });
        }
        formation.setNom(dto.getNom());
        formation.setCode(dto.getCode());
        formation.setDescription(dto.getDescription());
        formation.setStatut(dto.getStatut());
        formation.setNiveauEtude(dto.getNiveauEtude());
        formation.setDuree(dto.getDuree());
        if (dto.getResponsableId() != null) {
            Utilisateur responsable = (Utilisateur)this.utilisateurRepository.findById((Object)dto.getResponsableId()).orElseThrow(() -> new EntityNotFoundException("Responsable p\u00e9dagogique non trouv\u00e9."));
            formation.setResponsablePedagogique(responsable);
        } else {
            formation.setResponsablePedagogique(null);
        }
        formation.setObjectifs(dto.getObjectifs());
        formation.setPrerequis(dto.getPrerequis());
        formation.setDebouches(dto.getDebouches());
        formation.setEvaluationModalites(dto.getEvaluationModalites());
        formation.setModaliteEnseignement(dto.getModaliteEnseignement());
        formation.setLieu(dto.getLieu());
        formation.setDateDebut(dto.getDateDebut() != null ? dto.getDateDebut().atStartOfDay() : null);
        formation.setDateFin(dto.getDateFin() != null ? dto.getDateFin().atStartOfDay() : null);
        formation.setCapacite(dto.getCapacite());
        formation.setTarif(dto.getTarif());
        formation.setCertificationProfessionnelle(dto.getCertificationProfessionnelle());
        if (dto.getEtablissementId() != null) {
            Etablissement etablissement = (Etablissement)this.etablissementRepository.findById((Object)dto.getEtablissementId()).orElseThrow(() -> new EntityNotFoundException("\u00c9tablissement non trouv\u00e9 avec l'ID: " + dto.getEtablissementId()));
            formation.setEtablissement(etablissement);
        } else {
            formation.setEtablissement(null);
        }
        if (dto.getUefrId() != null) {
            Uefr uefr = (Uefr)this.uefrRepository.findById((Object)dto.getUefrId()).orElseThrow(() -> new EntityNotFoundException("UFR non trouv\u00e9e avec l'ID: " + dto.getUefrId()));
            formation.setUefr(uefr);
        } else {
            formation.setUefr(null);
        }
        if (dto.getDepartementId() != null) {
            Departement departement = (Departement)this.departementRepository.findById((Object)dto.getDepartementId()).orElseThrow(() -> new EntityNotFoundException("D\u00e9partement non trouv\u00e9 avec l'ID: " + dto.getDepartementId()));
            formation.setDepartement(departement);
        } else {
            formation.setDepartement(null);
        }
        formation.getCompetences().clear();
        if (dto.getCompetences() != null) {
            dto.getCompetences().forEach(compDto -> {
                CompetenceDetail competence = new CompetenceDetail();
                competence.setLibelle(compDto.getLibelle());
                competence.setNiveauAcquisition(NiveauAcquisition.valueOf((String)compDto.getNiveauAcquisition()));
                competence.setIndicateursEvaluation(compDto.getIndicateursEvaluation());
                competence.setFormation(formation);
                formation.getCompetences().add(competence);
            });
        }
        formation.getUnitesEnseignement().clear();
        if (dto.getUnitesEnseignement() != null) {
            dto.getUnitesEnseignement().forEach(ueDto -> {
                UniteEnseignement ue = new UniteEnseignement();
                ue.setNom(ueDto.getNom());
                ue.setCode(ueDto.getCode());
                ue.setDescription(ueDto.getDescription());
                ue.setEcts(ueDto.getEcts());
                ue.setSemestre(ueDto.getSemestre());
                ue.setObjectifs(ueDto.getObjectifs());
                ue.setVolumeHoraireCours(ueDto.getVolumeHoraireCours());
                ue.setVolumeHoraireTD(ueDto.getVolumeHoraireTD());
                ue.setVolumeHoraireTP(ueDto.getVolumeHoraireTP());
                ue.setFormation(formation);
                if (ueDto.getResponsableId() != null) {
                    Utilisateur respUe = (Utilisateur)this.utilisateurRepository.findById((Object)ueDto.getResponsableId()).orElseThrow(() -> new EntityNotFoundException("Responsable UE non trouv\u00e9."));
                    ue.setResponsable(respUe);
                }
                if (ueDto.getElementConstitutifIds() != null && !ueDto.getElementConstitutifIds().isEmpty()) {
                    List elements = this.elementConstitutifRepository.findAllById((Iterable)ueDto.getElementConstitutifIds());
                    ue.setElementsConstitutifs(elements);
                }
                formation.getUnitesEnseignement().add(ue);
            });
        }
        Formation updated = (Formation)this.formationRepository.save((Object)formation);
        return new FormationDetailDto(updated);
    }

    @Transactional
    public void supprimerFormation(Long id) {
        Formation formation = (Formation)this.formationRepository.findById((Object)id).orElseThrow(() -> new EntityNotFoundException("Formation non trouv\u00e9e."));
        if (formation.getElementsConstitutifs() != null) {
            formation.getElementsConstitutifs().forEach(ec -> ec.setFormation(null));
            formation.getElementsConstitutifs().clear();
        }
        this.formationRepository.delete((Object)formation);
    }
}

