/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.service;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FileStorageService {
    private final Path fileStorageLocation;

    public FileStorageService(@Value(value="${file.upload-dir}") String uploadDir) {
        this.fileStorageLocation = Paths.get(uploadDir, new String[0]).toAbsolutePath().normalize();
        try {
            Files.createDirectories(this.fileStorageLocation, new FileAttribute[0]);
        }
        catch (Exception ex) {
            throw new RuntimeException("Impossible de cr\u00e9er le dossier de stockage des fichiers.", ex);
        }
    }

    public String storeFile(MultipartFile file) {
        String originalFileName = StringUtils.cleanPath((String)file.getOriginalFilename());
        try {
            if (originalFileName.contains("..")) {
                throw new RuntimeException("D\u00e9sol\u00e9 ! Le nom du fichier contient une s\u00e9quence invalide " + originalFileName);
            }
            String fileExtension = "";
            try {
                fileExtension = originalFileName.substring(originalFileName.lastIndexOf("."));
            }
            catch (Exception exception) {
                // empty catch block
            }
            String uniqueFileName = UUID.randomUUID().toString() + fileExtension;
            Path targetLocation = this.fileStorageLocation.resolve(uniqueFileName);
            Files.copy(file.getInputStream(), targetLocation, StandardCopyOption.REPLACE_EXISTING);
            return uniqueFileName;
        }
        catch (IOException ex) {
            throw new RuntimeException("Impossible de stocker le fichier " + originalFileName + ". Veuillez r\u00e9essayer !", ex);
        }
    }
}

