/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.service;

import com.moscepa.dto.EtablissementDTO;
import com.moscepa.entity.Etablissement;
import com.moscepa.exception.ResourceNotFoundException;
import com.moscepa.repository.EtablissementRepository;
import java.util.List;
import java.util.stream.Collectors;
import org.modelmapper.ModelMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class EtablissementService {
    private final EtablissementRepository etablissementRepository;
    private final ModelMapper modelMapper;

    @Autowired
    public EtablissementService(EtablissementRepository etablissementRepository, ModelMapper modelMapper) {
        this.etablissementRepository = etablissementRepository;
        this.modelMapper = modelMapper;
    }

    public List<EtablissementDTO> getAllEtablissements() {
        return this.etablissementRepository.findAll().stream().map(arg_0 -> this.convertToDTO(arg_0)).collect(Collectors.toList());
    }

    public EtablissementDTO getEtablissementById(Long id) {
        Etablissement etablissement = (Etablissement)this.etablissementRepository.findById((Object)id).orElseThrow(() -> new ResourceNotFoundException("\u00c9tablissement non trouv\u00e9 avec l'ID : " + id));
        return this.convertToDTO(etablissement);
    }

    public EtablissementDTO createEtablissement(EtablissementDTO etablissementDTO) {
        if (this.etablissementRepository.existsBySigle(etablissementDTO.getSigle())) {
            throw new IllegalArgumentException("Un \u00e9tablissement avec ce sigle existe d\u00e9j\u00e0");
        }
        Etablissement etablissement = this.convertToEntity(etablissementDTO);
        Etablissement savedEtablissement = (Etablissement)this.etablissementRepository.save((Object)etablissement);
        return this.convertToDTO(savedEtablissement);
    }

    public EtablissementDTO updateEtablissement(Long id, EtablissementDTO etablissementDTO) {
        Etablissement existingEtablissement = (Etablissement)this.etablissementRepository.findById((Object)id).orElseThrow(() -> new ResourceNotFoundException("\u00c9tablissement non trouv\u00e9 avec l'ID : " + id));
        if (!existingEtablissement.getSigle().equals(etablissementDTO.getSigle()) && this.etablissementRepository.existsBySigleAndIdNot(etablissementDTO.getSigle(), id)) {
            throw new IllegalArgumentException("Un \u00e9tablissement avec ce sigle existe d\u00e9j\u00e0");
        }
        existingEtablissement.setNom(etablissementDTO.getNom());
        existingEtablissement.setSigle(etablissementDTO.getSigle());
        existingEtablissement.setAdresse(etablissementDTO.getAdresse());
        existingEtablissement.setContact(etablissementDTO.getContact());
        existingEtablissement.setLogo(etablissementDTO.getLogo());
        existingEtablissement.setLien(etablissementDTO.getLien());
        Etablissement updatedEtablissement = (Etablissement)this.etablissementRepository.save((Object)existingEtablissement);
        return this.convertToDTO(updatedEtablissement);
    }

    public void deleteEtablissement(Long id) {
        if (!this.etablissementRepository.existsById((Object)id)) {
            throw new ResourceNotFoundException("\u00c9tablissement non trouv\u00e9 avec l'ID : " + id);
        }
        this.etablissementRepository.deleteById((Object)id);
    }

    private EtablissementDTO convertToDTO(Etablissement etablissement) {
        return (EtablissementDTO)this.modelMapper.map((Object)etablissement, EtablissementDTO.class);
    }

    private Etablissement convertToEntity(EtablissementDTO etablissementDTO) {
        return (Etablissement)this.modelMapper.map((Object)etablissementDTO, Etablissement.class);
    }
}

