/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.security;

import com.moscepa.entity.Utilisateur;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class UserPrincipal
implements UserDetails {
    private Long id;
    private String email;
    private String motDePasse;
    private Collection<? extends GrantedAuthority> authorities;

    public UserPrincipal(Long id, String email, String motDePasse, Collection<? extends GrantedAuthority> authorities) {
        this.id = id;
        this.email = email;
        this.motDePasse = motDePasse;
        this.authorities = authorities;
    }

    public static UserPrincipal create(Utilisateur utilisateur) {
        ArrayList<Object> roleAuthorities = new ArrayList<Object>();
        if (utilisateur.getRole() != null) {
            roleAuthorities.add(new SimpleGrantedAuthority("ROLE_" + utilisateur.getRole().name()));
        }
        if (utilisateur.getPermissions() != null && !utilisateur.getPermissions().isEmpty()) {
            List permissionAuthorities = utilisateur.getPermissions().stream().map(permission -> new SimpleGrantedAuthority(permission.getNom().replace(" ", "_").toUpperCase())).collect(Collectors.toList());
            roleAuthorities.addAll(permissionAuthorities);
        }
        return new UserPrincipal(utilisateur.getId(), utilisateur.getEmail(), utilisateur.getMotDePasse(), roleAuthorities);
    }

    public Long getId() {
        return this.id;
    }

    public String getEmail() {
        return this.email;
    }

    public String getUsername() {
        return this.email;
    }

    public String getPassword() {
        return this.motDePasse;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserPrincipal that = (UserPrincipal)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

