/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.security;

import com.moscepa.security.UserPrincipal;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.UnsupportedJwtException;
import io.jsonwebtoken.security.Keys;
import java.security.Key;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.stereotype.Component;

@Component
public class JwtUtils {
    private static final Logger logger = LoggerFactory.getLogger(JwtUtils.class);
    @Value(value="${moscepa.app.jwtSecret:mOsCePaSecretKeyForJWTTokenGenerationAndValidation2024}")
    private String jwtSecret;
    @Value(value="${moscepa.app.jwtExpirationMs:86400000}")
    private int jwtExpirationMs;

    private SecretKey getSigningKey() {
        return Keys.hmacShaKeyFor((byte[])this.jwtSecret.getBytes());
    }

    public String generateJwtToken(Authentication authentication) {
        UserPrincipal userPrincipal = (UserPrincipal)authentication.getPrincipal();
        List authorities = userPrincipal.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toList());
        return Jwts.builder().setSubject(userPrincipal.getEmail()).claim("authorities", authorities).setIssuedAt(new Date()).setExpiration(new Date(new Date().getTime() + (long)this.jwtExpirationMs)).signWith((Key)this.getSigningKey(), SignatureAlgorithm.HS256).compact();
    }

    public String generateTokenFromEmail(String email) {
        return Jwts.builder().setSubject(email).setIssuedAt(new Date()).setExpiration(new Date(new Date().getTime() + (long)this.jwtExpirationMs)).signWith((Key)this.getSigningKey(), SignatureAlgorithm.HS256).compact();
    }

    public String getEmailFromJwtToken(String token) {
        return ((Claims)Jwts.parserBuilder().setSigningKey((Key)this.getSigningKey()).build().parseClaimsJws(token).getBody()).getSubject();
    }

    public boolean validateJwtToken(String authToken) {
        try {
            Jwts.parserBuilder().setSigningKey((Key)this.getSigningKey()).build().parseClaimsJws(authToken);
            return true;
        }
        catch (MalformedJwtException e) {
            logger.error("Token JWT invalide: {}", (Object)e.getMessage());
        }
        catch (ExpiredJwtException e) {
            logger.error("Token JWT expir\u00e9: {}", (Object)e.getMessage());
        }
        catch (UnsupportedJwtException e) {
            logger.error("Token JWT non support\u00e9: {}", (Object)e.getMessage());
        }
        catch (IllegalArgumentException e) {
            logger.error("JWT claims string est vide: {}", (Object)e.getMessage());
        }
        return false;
    }
}

