/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.security;

import com.moscepa.security.JwtUtils;
import com.moscepa.security.UserDetailsServiceImpl;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureException;
import io.jsonwebtoken.UnsupportedJwtException;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class AuthTokenFilter
extends OncePerRequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(AuthTokenFilter.class);
    @Autowired
    private JwtUtils jwtUtils;
    @Autowired
    private UserDetailsServiceImpl userDetailsService;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        logger.info("AuthTokenFilter: Traitement de la requ\u00eate pour l'URL : {}", (Object)request.getRequestURI());
        try {
            String jwt = this.parseJwt(request);
            if (jwt == null) {
                logger.warn("AuthTokenFilter: Aucun jeton JWT trouv\u00e9 dans l'en-t\u00eate 'Authorization' pour l'URL : {}", (Object)request.getRequestURI());
            } else if (this.jwtUtils.validateJwtToken(jwt)) {
                String email = this.jwtUtils.getEmailFromJwtToken(jwt);
                UserDetails userDetails = this.userDetailsService.loadUserByUsername(email);
                UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
                authentication.setDetails((Object)new WebAuthenticationDetailsSource().buildDetails(request));
                SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
                logger.info("AuthTokenFilter: Utilisateur '{}' authentifi\u00e9 avec succ\u00e8s pour l'URL : {}", (Object)email, (Object)request.getRequestURI());
            } else {
                logger.warn("AuthTokenFilter: La validation du jeton JWT a \u00e9chou\u00e9 (validateJwtToken a retourn\u00e9 false).");
            }
        }
        catch (SignatureException e) {
            logger.error("ERREUR CACH\u00c9E D\u00c9TECT\u00c9E : Signature JWT invalide ! D\u00e9tails : {}", (Object)e.getMessage());
        }
        catch (MalformedJwtException e) {
            logger.error("ERREUR CACH\u00c9E D\u00c9TECT\u00c9E : Token JWT malform\u00e9 ! Le token re\u00e7u n'est pas un JWT valide. D\u00e9tails : {}", (Object)e.getMessage());
        }
        catch (ExpiredJwtException e) {
            logger.error("ERREUR CACH\u00c9E D\u00c9TECT\u00c9E : Le token JWT a expir\u00e9 ! D\u00e9tails : {}", (Object)e.getMessage());
        }
        catch (UnsupportedJwtException e) {
            logger.error("ERREUR CACH\u00c9E D\u00c9TECT\u00c9E : Token JWT non support\u00e9 ! D\u00e9tails : {}", (Object)e.getMessage());
        }
        catch (IllegalArgumentException e) {
            logger.error("ERREUR CACH\u00c9E D\u00c9TECT\u00c9E : Argument invalide pass\u00e9 \u00e0 une m\u00e9thode JWT ! D\u00e9tails : {}", (Object)e.getMessage());
        }
        catch (Exception e) {
            logger.error("ERREUR CRITIQUE INATTENDUE lors du traitement du jeton JWT.", (Throwable)e);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private String parseJwt(HttpServletRequest request) {
        String headerAuth = request.getHeader("Authorization");
        if (StringUtils.hasText((String)headerAuth) && headerAuth.startsWith("Bearer ")) {
            return headerAuth.substring(7);
        }
        return null;
    }
}

