/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.security;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.stereotype.Component;

@Component
public class AuthEntryPointJwt
implements AuthenticationEntryPoint {
    private static final Logger logger = LoggerFactory.getLogger(AuthEntryPointJwt.class);

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        logger.error("Erreur d'authentification: {}", (Object)authException.getMessage());
        response.setContentType("application/json");
        response.setStatus(401);
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("status", 401);
        body.put("error", "Non autoris\u00e9");
        body.put("message", "Acc\u00e8s refus\u00e9 - Token d'authentification requis");
        body.put("path", request.getServletPath());
        ObjectMapper mapper = new ObjectMapper();
        mapper.writeValue((OutputStream)response.getOutputStream(), body);
    }
}

