/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.repository;

import com.moscepa.entity.Role;
import com.moscepa.entity.Utilisateur;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface UtilisateurRepository
extends JpaRepository<Utilisateur, Long> {
    public Optional<Utilisateur> findByEmail(String var1);

    public boolean existsByEmail(String var1);

    public List<Utilisateur> findByRole(Role var1);

    public List<Utilisateur> findByActifTrue();

    public List<Utilisateur> findByRoleAndActifTrue(Role var1);

    @Query(value="SELECT u FROM Utilisateur u WHERE LOWER(u.nom) LIKE LOWER(CONCAT('%', :searchTerm, '%')) OR LOWER(u.prenom) LIKE LOWER(CONCAT('%', :searchTerm, '%'))")
    public List<Utilisateur> findByNomOrPrenomContainingIgnoreCase(@Param(value="searchTerm") String var1);

    @Query(value="SELECT u FROM Utilisateur u WHERE u.role = 'ENSEIGNANT' AND u.actif = true")
    public List<Utilisateur> findAllEnseignantsActifs();

    public List<Utilisateur> findAllByOrderByDateCreationDesc();

    public List<Utilisateur> findByRoleOrderByNomAscPrenomAsc(Role var1);

    @Query(value="SELECT COUNT(u) FROM Utilisateur u WHERE u.role = :role")
    public long countByRole(@Param(value="role") Role var1);

    @Query(value="SELECT u FROM Utilisateur u WHERE u.role = 'ADMIN'")
    public List<Utilisateur> findAllAdmins();

    public List<Utilisateur> findByRole(String var1);

    public List<Utilisateur> findAllByFormationActuelle(String var1);
}

