/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.repository;

import com.moscepa.entity.ResultatTest;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface ResultatTestRepository
extends JpaRepository<ResultatTest, Long> {
    public Optional<ResultatTest> findByEtudiantIdAndTestId(Long var1, Long var2);

    @Query(value="SELECT r FROM ResultatTest r WHERE r.etudiant.id = :etudiantId AND r.test.chapitre.elementConstitutif.id = :matiereId ORDER BY r.dateTest DESC")
    public List<ResultatTest> findByEtudiantIdAndMatiereId(@Param(value="etudiantId") Long var1, @Param(value="matiereId") Long var2);

    @Query(value="SELECT r FROM ResultatTest r WHERE r.etudiant.id = :etudiantId AND r.test.chapitre.id = :chapitreId ORDER BY r.dateTest DESC")
    public List<ResultatTest> findLatestByEtudiantAndChapitre(@Param(value="etudiantId") Long var1, @Param(value="chapitreId") Long var2);

    public List<ResultatTest> findByEtudiantIdOrderByDateTestDesc(Long var1);

    public Optional<ResultatTest> findTopByEtudiantIdAndTestIdOrderByDateTestDesc(Long var1, Long var2);

    @Query(value="SELECT DISTINCT rt FROM ResultatTest rt JOIN FETCH rt.test t JOIN FETCH t.chapitre c JOIN FETCH c.elementConstitutif ec WHERE rt.etudiant.id = :etudiantId")
    public List<ResultatTest> findByEtudiantIdWithDetails(@Param(value="etudiantId") Long var1);

    @Query(value="SELECT r FROM ResultatTest r JOIN FETCH r.test t JOIN FETCH t.chapitre c JOIN FETCH c.elementConstitutif ec WHERE r.etudiant.id = :etudiantId ORDER BY r.dateTest DESC")
    public List<ResultatTest> findFullResultsByEtudiant(@Param(value="etudiantId") Long var1);
}

