/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.entity;

import com.moscepa.entity.Formation;
import com.moscepa.entity.Permission;
import com.moscepa.entity.Role;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Email;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

@Entity
@Table(name="moscepa_utilisateurs")
public class Utilisateur {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @NotBlank
    @Size(max=100)
    @Column(nullable=false, length=100)
    private @NotBlank @Size(max=100) String nom;
    @NotBlank
    @Size(max=100)
    @Column(nullable=false, length=100)
    private @NotBlank @Size(max=100) String prenom;
    @NotBlank
    @Email
    @Size(max=255)
    @Column(nullable=false, unique=true, length=255)
    private @NotBlank @Email @Size(max=255) String email;
    @NotBlank
    @Column(nullable=false)
    private String motDePasse;
    @Enumerated(value=EnumType.STRING)
    @Column(nullable=false)
    private Role role;
    @Column(nullable=false)
    private Boolean actif = true;
    @Column(name="date_de_naissance")
    private String dateDeNaissance;
    @Column(name="lieu_de_naissance")
    private String lieuDeNaissance;
    private String nationalite;
    private String sexe;
    private String adresse;
    private String telephone;
    private String formationActuelle;
    private String niveauEtude;
    private String parcoursType;
    @Column(name="annee_academique")
    private String anneeAcademique;
    private String filiere;
    @CreationTimestamp
    @Column(updatable=false)
    private LocalDateTime dateCreation;
    @UpdateTimestamp
    private LocalDateTime dateModification;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="moscepa_utilisateur_permissions", joinColumns={@JoinColumn(name="utilisateur_id")}, inverseJoinColumns={@JoinColumn(name="permission_id")})
    private Set<Permission> permissions = new HashSet();
    @OneToMany(mappedBy="createur", fetch=FetchType.LAZY)
    private List<Formation> formationsCrees;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNom() {
        return this.nom;
    }

    public void setNom(String nom) {
        this.nom = nom;
    }

    public String getPrenom() {
        return this.prenom;
    }

    public void setPrenom(String prenom) {
        this.prenom = prenom;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getMotDePasse() {
        return this.motDePasse;
    }

    public void setMotDePasse(String motDePasse) {
        this.motDePasse = motDePasse;
    }

    public Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    public Boolean getActif() {
        return this.actif;
    }

    public void setActif(Boolean actif) {
        this.actif = actif;
    }

    public String getDateDeNaissance() {
        return this.dateDeNaissance;
    }

    public void setDateDeNaissance(String dateDeNaissance) {
        this.dateDeNaissance = dateDeNaissance;
    }

    public String getLieuDeNaissance() {
        return this.lieuDeNaissance;
    }

    public void setLieuDeNaissance(String lieuDeNaissance) {
        this.lieuDeNaissance = lieuDeNaissance;
    }

    public String getNationalite() {
        return this.nationalite;
    }

    public void setNationalite(String nationalite) {
        this.nationalite = nationalite;
    }

    public String getSexe() {
        return this.sexe;
    }

    public void setSexe(String sexe) {
        this.sexe = sexe;
    }

    public String getAdresse() {
        return this.adresse;
    }

    public void setAdresse(String adresse) {
        this.adresse = adresse;
    }

    public String getTelephone() {
        return this.telephone;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    public String getAnneeAcademique() {
        return this.anneeAcademique;
    }

    public void setAnneeAcademique(String anneeAcademique) {
        this.anneeAcademique = anneeAcademique;
    }

    public String getFiliere() {
        return this.filiere;
    }

    public void setFiliere(String filiere) {
        this.filiere = filiere;
    }

    public LocalDateTime getDateCreation() {
        return this.dateCreation;
    }

    public void setDateCreation(LocalDateTime dateCreation) {
        this.dateCreation = dateCreation;
    }

    public LocalDateTime getDateModification() {
        return this.dateModification;
    }

    public void setDateModification(LocalDateTime dateModification) {
        this.dateModification = dateModification;
    }

    public Set<Permission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Set<Permission> permissions) {
        this.permissions = permissions;
    }

    public String getFormationActuelle() {
        return this.formationActuelle;
    }

    public void setFormationActuelle(String formationActuelle) {
        this.formationActuelle = formationActuelle;
    }

    public String getNiveauEtude() {
        return this.niveauEtude;
    }

    public void setNiveauEtude(String niveauEtude) {
        this.niveauEtude = niveauEtude;
    }

    public String getParcoursType() {
        return this.parcoursType;
    }

    public void setParcoursType(String parcoursType) {
        this.parcoursType = parcoursType;
    }

    public List<Formation> getFormationsCrees() {
        return this.formationsCrees;
    }

    public Set<String> getRoles() {
        HashSet<String> roles = new HashSet<String>();
        roles.add(this.role.name());
        return roles;
    }
}

