/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.moscepa.entity.Departement;
import com.moscepa.entity.Etablissement;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

@Entity
@Table(name="moscepa_uefrs")
public class Uefr {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @NotBlank(message="Le nom est obligatoire")
    @Size(min=2, max=100, message="Le nom doit contenir entre 2 et 100 caract\u00e8res")
    @Column(nullable=false, length=100)
    private @NotBlank(message="Le nom est obligatoire") @Size(min=2, max=100, message="Le nom doit contenir entre 2 et 100 caract\u00e8res") String nom;
    @NotBlank(message="Le sigle est obligatoire")
    @Size(min=2, max=10, message="Le sigle doit contenir entre 2 et 10 caract\u00e8res")
    @Column(unique=true, nullable=false, length=10)
    private @NotBlank(message="Le sigle est obligatoire") @Size(min=2, max=10, message="Le sigle doit contenir entre 2 et 10 caract\u00e8res") String sigle;
    @NotBlank(message="L'adresse est obligatoire")
    @Size(max=200, message="L'adresse ne doit pas d\u00e9passer 200 caract\u00e8res")
    @Column(nullable=false, length=200)
    private @NotBlank(message="L'adresse est obligatoire") @Size(max=200, message="L'adresse ne doit pas d\u00e9passer 200 caract\u00e8res") String adresse;
    @NotBlank(message="Le contact est obligatoire")
    @Size(max=50, message="Le contact ne doit pas d\u00e9passer 50 caract\u00e8res")
    @Column(nullable=false, length=50)
    private @NotBlank(message="Le contact est obligatoire") @Size(max=50, message="Le contact ne doit pas d\u00e9passer 50 caract\u00e8res") String contact;
    @Column(length=255)
    private String logo;
    @Column(length=255)
    private String lien;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="etablissement_id", nullable=false)
    @NotNull(message="L'\u00e9tablissement est obligatoire")
    private @NotNull(message="L'\u00e9tablissement est obligatoire") Etablissement etablissement;
    @OneToMany(mappedBy="uefr", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JsonIgnore
    private List<Departement> departements = new ArrayList();
    @CreationTimestamp
    @Column(name="created_at", updatable=false)
    private LocalDateTime createdAt;
    @UpdateTimestamp
    @Column(name="updated_at")
    private LocalDateTime updatedAt;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNom() {
        return this.nom;
    }

    public void setNom(String nom) {
        this.nom = nom;
    }

    public String getSigle() {
        return this.sigle;
    }

    public void setSigle(String sigle) {
        this.sigle = sigle;
    }

    public String getAdresse() {
        return this.adresse;
    }

    public void setAdresse(String adresse) {
        this.adresse = adresse;
    }

    public String getContact() {
        return this.contact;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public String getLogo() {
        return this.logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public String getLien() {
        return this.lien;
    }

    public void setLien(String lien) {
        this.lien = lien;
    }

    public Etablissement getEtablissement() {
        return this.etablissement;
    }

    public void setEtablissement(Etablissement etablissement) {
        this.etablissement = etablissement;
    }

    public List<Departement> getDepartements() {
        return this.departements;
    }

    public void setDepartements(List<Departement> departements) {
        this.departements = departements;
    }

    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public LocalDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(LocalDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }
}

