/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.entity;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.moscepa.entity.Test;
import com.moscepa.entity.Utilisateur;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.time.LocalDateTime;

@Entity
@Table(name="moscepa_resultats_tests")
public class ResultatTest {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="etudiant_id", nullable=false)
    @JsonBackReference(value="utilisateur-resultats")
    private Utilisateur etudiant;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="test_id", nullable=false)
    @JsonBackReference(value="test-resultats")
    private Test test;
    @Column(name="score", nullable=false)
    private Double score;
    @Column(name="score_total", nullable=false)
    private Double scoreTotal;
    @Column(name="date_test", nullable=false)
    private LocalDateTime dateTest = LocalDateTime.now();
    @Column(name="bonnes_reponses", nullable=false)
    private int bonnesReponses;
    @Column(name="total_questions", nullable=false)
    private int totalQuestions;
    @Transient
    private Double pourcentage;

    public Double getPourcentage() {
        if (this.scoreTotal != null && this.scoreTotal > 0.0) {
            return this.score / this.scoreTotal * 100.0;
        }
        return 0.0;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Utilisateur getEtudiant() {
        return this.etudiant;
    }

    public void setEtudiant(Utilisateur etudiant) {
        this.etudiant = etudiant;
    }

    public Test getTest() {
        return this.test;
    }

    public void setTest(Test test) {
        this.test = test;
    }

    public Double getScore() {
        return this.score;
    }

    public void setScore(Double score) {
        this.score = score;
    }

    public Double getScoreTotal() {
        return this.scoreTotal;
    }

    public void setScoreTotal(Double scoreTotal) {
        this.scoreTotal = scoreTotal;
    }

    public LocalDateTime getDateTest() {
        return this.dateTest;
    }

    public void setDateTest(LocalDateTime dateTest) {
        this.dateTest = dateTest;
    }

    public int getBonnesReponses() {
        return this.bonnesReponses;
    }

    public void setBonnesReponses(int bonnesReponses) {
        this.bonnesReponses = bonnesReponses;
    }

    public int getTotalQuestions() {
        return this.totalQuestions;
    }

    public void setTotalQuestions(int totalQuestions) {
        this.totalQuestions = totalQuestions;
    }

    public String toString() {
        return "ResultatTest{id=" + this.id + ", score=" + this.score + ", scoreTotal=" + this.scoreTotal + ", dateTest=" + String.valueOf(this.dateTest) + ", bonnesReponses=" + this.bonnesReponses + ", totalQuestions=" + this.totalQuestions + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResultatTest that = (ResultatTest)o;
        return this.id != null && this.id.equals(that.id);
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

