/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.entity;

import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.moscepa.entity.Chapitre;
import com.moscepa.entity.Question;
import com.moscepa.entity.Test;
import com.moscepa.entity.TypeQuestionnaire;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.PrePersist;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

@Entity
@Table(name="moscepa_questionnaires")
public class Questionnaire {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(nullable=false)
    private String titre;
    @Enumerated(value=EnumType.STRING)
    @Column(name="type", nullable=false)
    private TypeQuestionnaire type = TypeQuestionnaire.TEST;
    private String matiere;
    private int duree;
    @Column(columnDefinition="TEXT")
    private String description;
    @Column(nullable=false, updatable=false)
    private LocalDateTime dateCreation;
    private String auteur;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="chapitre_id", nullable=false)
    private Chapitre chapitre;
    @OneToMany(mappedBy="questionnaire", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JsonManagedReference(value="questionnaire-questions")
    private List<Question> questions = new ArrayList();
    @OneToMany(mappedBy="questionnaire", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JsonManagedReference(value="questionnaire-tests")
    private List<Test> tests = new ArrayList();

    @PrePersist
    public void onPrePersist() {
        this.dateCreation = LocalDateTime.now();
    }

    public void addQuestion(Question question) {
        this.questions.add(question);
        question.setQuestionnaire(this);
    }

    public void removeQuestion(Question question) {
        this.questions.remove(question);
        question.setQuestionnaire(null);
    }

    public void addTest(Test test) {
        this.tests.add(test);
        test.setQuestionnaire(this);
    }

    public void removeTest(Test test) {
        this.tests.remove(test);
        test.setQuestionnaire(null);
    }

    public boolean tentativesIllimitees() {
        return this.type == TypeQuestionnaire.EXERCICE || this.type == TypeQuestionnaire.QUIZ;
    }

    public int tentativesMaxParDefaut() {
        return this.type == TypeQuestionnaire.TEST ? 1 : Integer.MAX_VALUE;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitre() {
        return this.titre;
    }

    public void setTitre(String titre) {
        this.titre = titre;
    }

    public TypeQuestionnaire getType() {
        return this.type;
    }

    public void setType(TypeQuestionnaire type) {
        this.type = type;
    }

    public String getMatiere() {
        return this.matiere;
    }

    public void setMatiere(String matiere) {
        this.matiere = matiere;
    }

    public int getDuree() {
        return this.duree;
    }

    public void setDuree(int duree) {
        this.duree = duree;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public LocalDateTime getDateCreation() {
        return this.dateCreation;
    }

    public void setDateCreation(LocalDateTime dateCreation) {
        this.dateCreation = dateCreation;
    }

    public String getAuteur() {
        return this.auteur;
    }

    public void setAuteur(String auteur) {
        this.auteur = auteur;
    }

    public Chapitre getChapitre() {
        return this.chapitre;
    }

    public void setChapitre(Chapitre chapitre) {
        this.chapitre = chapitre;
    }

    public List<Question> getQuestions() {
        return this.questions;
    }

    public void setQuestions(List<Question> questions) {
        this.questions = questions;
    }

    public List<Test> getTests() {
        return this.tests;
    }

    public void setTests(List<Test> tests) {
        this.tests = tests;
    }

    public String toString() {
        return "Questionnaire{id=" + this.id + ", titre='" + this.titre + "', type=" + String.valueOf(this.type) + ", matiere='" + this.matiere + "', duree=" + this.duree + ", description='" + this.description + "', dateCreation=" + String.valueOf(this.dateCreation) + ", auteur='" + this.auteur + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Questionnaire that = (Questionnaire)o;
        return this.id != null && this.id.equals(that.id);
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

