/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.entity;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.moscepa.entity.Chapitre;
import com.moscepa.entity.Questionnaire;
import com.moscepa.entity.Reponse;
import com.moscepa.entity.Test;
import com.moscepa.entity.TypeQuestion;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderBy;
import jakarta.persistence.Table;
import java.util.ArrayList;
import java.util.List;

@Entity
@Table(name="moscepa_questions")
public class Question {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="question_text", columnDefinition="TEXT", nullable=false)
    private String enonce;
    @Enumerated(value=EnumType.STRING)
    @Column(name="type_question", nullable=false)
    private TypeQuestion typeQuestion = TypeQuestion.QCM;
    @Column(nullable=false)
    private double points = 1.0;
    @Column(name="reponse_correcte_texte")
    private String reponseCorrecteTexte;
    @Column(name="theme")
    private String theme;
    @Column(name="niveau")
    private String niveau;
    @OneToMany(mappedBy="question", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.EAGER)
    @OrderBy(value="id ASC")
    @JsonManagedReference(value="question-reponses")
    private List<Reponse> reponses = new ArrayList();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="questionnaire_id")
    @JsonBackReference(value="questionnaire-questions")
    private Questionnaire questionnaire;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="chapitre_id")
    @JsonBackReference(value="chapitre-questions")
    private Chapitre chapitre;
    @ManyToMany(mappedBy="questions")
    @JsonIgnore
    private List<Test> tests = new ArrayList();

    public void addReponse(Reponse reponse) {
        this.reponses.add(reponse);
        reponse.setQuestion(this);
    }

    public void removeReponse(Reponse reponse) {
        this.reponses.remove(reponse);
        reponse.setQuestion(null);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getEnonce() {
        return this.enonce;
    }

    public void setEnonce(String enonce) {
        this.enonce = enonce;
    }

    public TypeQuestion getTypeQuestion() {
        return this.typeQuestion;
    }

    public void setTypeQuestion(TypeQuestion typeQuestion) {
        this.typeQuestion = typeQuestion;
    }

    public double getPoints() {
        return this.points;
    }

    public void setPoints(double points) {
        this.points = points;
    }

    public String getReponseCorrecteTexte() {
        return this.reponseCorrecteTexte;
    }

    public void setReponseCorrecteTexte(String reponseCorrecteTexte) {
        this.reponseCorrecteTexte = reponseCorrecteTexte;
    }

    public String getTheme() {
        return this.theme;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    public String getNiveau() {
        return this.niveau;
    }

    public void setNiveau(String niveau) {
        this.niveau = niveau;
    }

    public List<Reponse> getReponses() {
        return this.reponses;
    }

    public void setReponses(List<Reponse> reponses) {
        this.reponses = reponses;
    }

    public Questionnaire getQuestionnaire() {
        return this.questionnaire;
    }

    public void setQuestionnaire(Questionnaire questionnaire) {
        this.questionnaire = questionnaire;
    }

    public Chapitre getChapitre() {
        return this.chapitre;
    }

    public void setChapitre(Chapitre chapitre) {
        this.chapitre = chapitre;
    }

    public List<Test> getTests() {
        return this.tests;
    }

    public void setTests(List<Test> tests) {
        this.tests = tests;
    }

    public String toString() {
        return "Question{id=" + this.id + ", enonce='" + this.enonce + "', typeQuestion=" + String.valueOf(this.typeQuestion) + ", points=" + this.points + ", theme='" + this.theme + "', niveau='" + this.niveau + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Question question = (Question)o;
        return this.id != null && this.id.equals(question.id);
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

