/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.moscepa.entity.CompetenceDetail;
import com.moscepa.entity.Departement;
import com.moscepa.entity.ElementConstitutif;
import com.moscepa.entity.Etablissement;
import com.moscepa.entity.NiveauEtude;
import com.moscepa.entity.StatutFormation;
import com.moscepa.entity.Uefr;
import com.moscepa.entity.UniteEnseignement;
import com.moscepa.entity.Utilisateur;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Entity
@Table(name="moscepa_formations")
public class Formation {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(nullable=false, unique=true)
    private String nom;
    @Column(nullable=false, unique=true, length=50)
    private String code;
    @Column(columnDefinition="TEXT")
    private String description;
    @Enumerated(value=EnumType.STRING)
    @Column(nullable=false)
    private StatutFormation statut = StatutFormation.EN_PREPARATION;
    @Enumerated(value=EnumType.STRING)
    @Column(nullable=false)
    private NiveauEtude niveauEtude = NiveauEtude.LICENCE;
    @Column(nullable=false)
    private Integer duree = 1;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="responsable_pedagogique_id")
    @JsonIgnore
    private Utilisateur responsablePedagogique;
    @Column(nullable=false)
    private LocalDateTime dateCreation = LocalDateTime.now();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="createur_id", nullable=false)
    @JsonIgnore
    private Utilisateur createur;
    @OneToMany(mappedBy="formation", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<ElementConstitutif> elementsConstitutifs = new HashSet();
    @Column(columnDefinition="TEXT")
    private String objectifs;
    @Column(columnDefinition="TEXT")
    private String prerequis;
    @Column(columnDefinition="TEXT")
    private String debouches;
    @Column(columnDefinition="TEXT")
    private String evaluationModalites;
    @Column(length=50)
    private String modaliteEnseignement;
    @Column(length=255)
    private String lieu;
    private LocalDateTime dateDebut;
    private LocalDateTime dateFin;
    private Integer capacite;
    private Double tarif;
    @Column(length=255)
    private String certificationProfessionnelle;
    @OneToMany(mappedBy="formation", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<CompetenceDetail> competences = new ArrayList();
    @OneToMany(mappedBy="formation", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<UniteEnseignement> unitesEnseignement = new ArrayList();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="etablissement_id", nullable=false)
    private Etablissement etablissement;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="uefr_id", nullable=false)
    private Uefr uefr;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="departement_id", nullable=false)
    private Departement departement;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNom() {
        return this.nom;
    }

    public void setNom(String nom) {
        this.nom = nom;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public StatutFormation getStatut() {
        return this.statut;
    }

    public void setStatut(StatutFormation statut) {
        this.statut = statut;
    }

    public NiveauEtude getNiveauEtude() {
        return this.niveauEtude;
    }

    public void setNiveauEtude(NiveauEtude niveauEtude) {
        this.niveauEtude = niveauEtude;
    }

    public Integer getDuree() {
        return this.duree;
    }

    public void setDuree(Integer duree) {
        this.duree = duree;
    }

    public Utilisateur getResponsablePedagogique() {
        return this.responsablePedagogique;
    }

    public void setResponsablePedagogique(Utilisateur responsablePedagogique) {
        this.responsablePedagogique = responsablePedagogique;
    }

    public LocalDateTime getDateCreation() {
        return this.dateCreation;
    }

    public void setDateCreation(LocalDateTime dateCreation) {
        this.dateCreation = dateCreation;
    }

    public Utilisateur getCreateur() {
        return this.createur;
    }

    public void setCreateur(Utilisateur createur) {
        this.createur = createur;
    }

    public Set<ElementConstitutif> getElementsConstitutifs() {
        return this.elementsConstitutifs;
    }

    public void setElementsConstitutifs(Set<ElementConstitutif> elementsConstitutifs) {
        this.elementsConstitutifs = elementsConstitutifs;
    }

    public String getObjectifs() {
        return this.objectifs;
    }

    public void setObjectifs(String objectifs) {
        this.objectifs = objectifs;
    }

    public String getPrerequis() {
        return this.prerequis;
    }

    public void setPrerequis(String prerequis) {
        this.prerequis = prerequis;
    }

    public String getDebouches() {
        return this.debouches;
    }

    public void setDebouches(String debouches) {
        this.debouches = debouches;
    }

    public String getEvaluationModalites() {
        return this.evaluationModalites;
    }

    public void setEvaluationModalites(String evaluationModalites) {
        this.evaluationModalites = evaluationModalites;
    }

    public String getModaliteEnseignement() {
        return this.modaliteEnseignement;
    }

    public void setModaliteEnseignement(String modaliteEnseignement) {
        this.modaliteEnseignement = modaliteEnseignement;
    }

    public String getLieu() {
        return this.lieu;
    }

    public void setLieu(String lieu) {
        this.lieu = lieu;
    }

    public LocalDateTime getDateDebut() {
        return this.dateDebut;
    }

    public void setDateDebut(LocalDateTime dateDebut) {
        this.dateDebut = dateDebut;
    }

    public LocalDateTime getDateFin() {
        return this.dateFin;
    }

    public void setDateFin(LocalDateTime dateFin) {
        this.dateFin = dateFin;
    }

    public Integer getCapacite() {
        return this.capacite;
    }

    public void setCapacite(Integer capacite) {
        this.capacite = capacite;
    }

    public Double getTarif() {
        return this.tarif;
    }

    public void setTarif(Double tarif) {
        this.tarif = tarif;
    }

    public String getCertificationProfessionnelle() {
        return this.certificationProfessionnelle;
    }

    public void setCertificationProfessionnelle(String certificationProfessionnelle) {
        this.certificationProfessionnelle = certificationProfessionnelle;
    }

    public List<CompetenceDetail> getCompetences() {
        return this.competences;
    }

    public void setCompetences(List<CompetenceDetail> competences) {
        this.competences = competences;
    }

    public List<UniteEnseignement> getUnitesEnseignement() {
        return this.unitesEnseignement;
    }

    public void setUnitesEnseignement(List<UniteEnseignement> unitesEnseignement) {
        this.unitesEnseignement = unitesEnseignement;
    }

    public void addElementConstitutif(ElementConstitutif ec) {
        this.elementsConstitutifs.add(ec);
        ec.setFormation(this);
    }

    public void removeElementConstitutif(ElementConstitutif ec) {
        this.elementsConstitutifs.remove(ec);
        ec.setFormation(null);
    }

    public Etablissement getEtablissement() {
        return this.etablissement;
    }

    public void setEtablissement(Etablissement etablissement) {
        this.etablissement = etablissement;
    }

    public Uefr getUefr() {
        return this.uefr;
    }

    public void setUefr(Uefr uefr) {
        this.uefr = uefr;
    }

    public Departement getDepartement() {
        return this.departement;
    }

    public void setDepartement(Departement departement) {
        this.departement = departement;
    }
}

