/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.entity;

import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.moscepa.entity.Chapitre;
import com.moscepa.entity.Formation;
import com.moscepa.entity.Test;
import com.moscepa.entity.UniteEnseignement;
import com.moscepa.entity.Utilisateur;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.util.ArrayList;
import java.util.List;

@Entity
@Table(name="moscepa_elements_constitutifs")
public class ElementConstitutif {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(nullable=false)
    private String nom;
    @Column(unique=true, nullable=false)
    private String code;
    @Lob
    private String description;
    @Column(name="credits", nullable=false)
    private Integer credit;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="unite_enseignement_id", nullable=false)
    private UniteEnseignement uniteEnseignement;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="enseignant_id")
    private Utilisateur enseignant;
    @Column(name="volume_horaire_cours", nullable=false)
    private Integer volumeHoraireCours = 0;
    @Column(name="volume_horaire_td", nullable=false)
    private Integer volumeHoraireTD = 0;
    @Column(name="volume_horaire_tp", nullable=false)
    private Integer volumeHoraireTP = 0;
    @OneToMany(mappedBy="elementConstitutif", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JsonManagedReference
    private List<Chapitre> chapitres = new ArrayList();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="formation_id")
    private Formation formation;
    @OneToMany(mappedBy="elementConstitutif", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<Test> tests = new ArrayList();

    public List<Test> getTests() {
        return this.tests;
    }

    public void setTests(List<Test> tests) {
        this.tests = tests;
    }

    public void addChapitre(Chapitre chapitre) {
        this.chapitres.add(chapitre);
        chapitre.setElementConstitutif(this);
    }

    public void removeChapitre(Chapitre chapitre) {
        this.chapitres.remove(chapitre);
        chapitre.setElementConstitutif(null);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNom() {
        return this.nom;
    }

    public void setNom(String nom) {
        this.nom = nom;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getCredit() {
        return this.credit;
    }

    public void setCredit(Integer credit) {
        this.credit = credit;
    }

    public UniteEnseignement getUniteEnseignement() {
        return this.uniteEnseignement;
    }

    public void setUniteEnseignement(UniteEnseignement uniteEnseignement) {
        this.uniteEnseignement = uniteEnseignement;
    }

    public Utilisateur getEnseignant() {
        return this.enseignant;
    }

    public void setEnseignant(Utilisateur enseignant) {
        this.enseignant = enseignant;
    }

    public List<Chapitre> getChapitres() {
        return this.chapitres;
    }

    public void setChapitres(List<Chapitre> chapitres) {
        this.chapitres = chapitres;
    }

    public Formation getFormation() {
        return this.formation;
    }

    public void setFormation(Formation formation) {
        this.formation = formation;
    }

    public Integer getVolumeHoraireCours() {
        return this.volumeHoraireCours;
    }

    public void setVolumeHoraireCours(Integer volumeHoraireCours) {
        this.volumeHoraireCours = volumeHoraireCours;
    }

    public Integer getVolumeHoraireTD() {
        return this.volumeHoraireTD;
    }

    public void setVolumeHoraireTD(Integer volumeHoraireTD) {
        this.volumeHoraireTD = volumeHoraireTD;
    }

    public Integer getVolumeHoraireTP() {
        return this.volumeHoraireTP;
    }

    public void setVolumeHoraireTP(Integer volumeHoraireTP) {
        this.volumeHoraireTP = volumeHoraireTP;
    }
}

