/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.dto;

import com.moscepa.dto.QuestionDto;
import com.moscepa.entity.Questionnaire;
import com.moscepa.entity.TypeQuestionnaire;
import java.util.List;
import java.util.stream.Collectors;

public class QuestionnaireDetailDto {
    private Long id;
    private String titre;
    private TypeQuestionnaire type;
    private String description;
    private int duree;
    private Long chapitreId;
    private String nomChapitre;
    private List<QuestionDto> questions;

    public QuestionnaireDetailDto() {
    }

    public QuestionnaireDetailDto(Questionnaire q) {
        this.id = q.getId();
        this.titre = q.getTitre();
        this.type = q.getType();
        this.description = q.getDescription();
        this.duree = q.getDuree();
        if (q.getChapitre() != null) {
            this.chapitreId = q.getChapitre().getId();
            this.nomChapitre = q.getChapitre().getNom();
        }
        if (q.getQuestions() != null) {
            this.questions = q.getQuestions().stream().map(QuestionDto::new).collect(Collectors.toList());
        }
    }

    public Questionnaire toEntity() {
        Questionnaire q = new Questionnaire();
        q.setId(this.id);
        q.setTitre(this.titre);
        q.setType(this.type);
        q.setDescription(this.description);
        q.setDuree(this.duree);
        return q;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitre() {
        return this.titre;
    }

    public void setTitre(String titre) {
        this.titre = titre;
    }

    public TypeQuestionnaire getType() {
        return this.type;
    }

    public void setType(TypeQuestionnaire type) {
        this.type = type;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getDuree() {
        return this.duree;
    }

    public void setDuree(int duree) {
        this.duree = duree;
    }

    public Long getChapitreId() {
        return this.chapitreId;
    }

    public void setChapitreId(Long chapitreId) {
        this.chapitreId = chapitreId;
    }

    public String getNomChapitre() {
        return this.nomChapitre;
    }

    public void setNomChapitre(String nomChapitre) {
        this.nomChapitre = nomChapitre;
    }

    public List<QuestionDto> getQuestions() {
        return this.questions;
    }

    public void setQuestions(List<QuestionDto> questions) {
        this.questions = questions;
    }

    public String toString() {
        return "QuestionnaireDetailDto{id=" + this.id + ", titre='" + this.titre + "', description='" + this.description + "', duree=" + this.duree + ", chapitreId=" + this.chapitreId + ", nomChapitre='" + this.nomChapitre + "', questions=" + (this.questions != null ? this.questions.size() : 0) + "}";
    }
}

