/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.dto;

import com.moscepa.dto.CompetenceDetailDto;
import com.moscepa.dto.FormationDetailDto;
import com.moscepa.dto.UniteEnseignementDto;
import com.moscepa.entity.Formation;
import com.moscepa.entity.NiveauEtude;
import com.moscepa.entity.StatutFormation;
import com.moscepa.entity.UniteEnseignement;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;

public class FormationDetailDto {
    private Long id;
    private String nom;
    private String code;
    private String description;
    private StatutFormation statut;
    private NiveauEtude niveauEtude;
    private Integer dureeAnnees;
    private String objectifs;
    private String prerequis;
    private String debouches;
    private String evaluationModalites;
    private String modaliteEnseignement;
    private String lieu;
    private String dateDebut;
    private String dateFin;
    private Integer capacite;
    private Double tarif;
    private String certificationProfessionnelle;
    private Long etablissementId;
    private String etablissementNom;
    private Long uefrId;
    private String uefrNom;
    private Long departementId;
    private String departementNom;
    private Integer volumeHoraireTotal;
    private Integer ectsTotal;
    private List<CompetenceDetailDto> competences;
    private List<UniteEnseignementDto> unitesEnseignement;
    private Long responsableId;
    private String responsableNom;
    private LocalDateTime dateCreation;
    private Long createurId;
    private String createurNom;
    private List<ElementConstitutifDto> elementsConstitutifs;

    public FormationDetailDto(Formation formation) {
        Integer totalVolume = formation.getUnitesEnseignement().stream().mapToInt(ue -> ue.getVolumeHoraireCours() + ue.getVolumeHoraireTD() + ue.getVolumeHoraireTP()).sum();
        Integer totalEcts = formation.getUnitesEnseignement().stream().mapToInt(UniteEnseignement::getEcts).sum();
        this.volumeHoraireTotal = totalVolume;
        this.ectsTotal = totalEcts;
        this.id = formation.getId();
        this.nom = formation.getNom();
        this.code = formation.getCode();
        this.description = formation.getDescription();
        this.statut = formation.getStatut();
        this.niveauEtude = formation.getNiveauEtude();
        this.dureeAnnees = formation.getDuree();
        this.objectifs = formation.getObjectifs();
        this.prerequis = formation.getPrerequis();
        this.debouches = formation.getDebouches();
        this.evaluationModalites = formation.getEvaluationModalites();
        this.modaliteEnseignement = formation.getModaliteEnseignement();
        this.lieu = formation.getLieu();
        this.dateDebut = formation.getDateDebut() != null ? formation.getDateDebut().toString() : null;
        this.dateFin = formation.getDateFin() != null ? formation.getDateFin().toString() : null;
        this.capacite = formation.getCapacite();
        this.tarif = formation.getTarif();
        this.certificationProfessionnelle = formation.getCertificationProfessionnelle();
        if (formation.getEtablissement() != null) {
            this.etablissementId = formation.getEtablissement().getId();
            this.etablissementNom = formation.getEtablissement().getNom();
        }
        if (formation.getUefr() != null) {
            this.uefrId = formation.getUefr().getId();
            this.uefrNom = formation.getUefr().getNom();
        }
        if (formation.getDepartement() != null) {
            this.departementId = formation.getDepartement().getId();
            this.departementNom = formation.getDepartement().getNom();
        }
        this.competences = formation.getCompetences().stream().map(CompetenceDetailDto::new).collect(Collectors.toList());
        this.unitesEnseignement = formation.getUnitesEnseignement().stream().map(UniteEnseignementDto::new).collect(Collectors.toList());
        this.dateCreation = formation.getDateCreation();
        if (formation.getResponsablePedagogique() != null) {
            this.responsableId = formation.getResponsablePedagogique().getId();
            this.responsableNom = formation.getResponsablePedagogique().getPrenom() + " " + formation.getResponsablePedagogique().getNom();
        }
        if (formation.getCreateur() != null) {
            this.createurId = formation.getCreateur().getId();
            this.createurNom = formation.getCreateur().getPrenom() + " " + formation.getCreateur().getNom();
        }
    }

    public Long getId() {
        return this.id;
    }

    public String getNom() {
        return this.nom;
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public StatutFormation getStatut() {
        return this.statut;
    }

    public NiveauEtude getNiveauEtude() {
        return this.niveauEtude;
    }

    public Integer getDureeAnnees() {
        return this.dureeAnnees;
    }

    public String getObjectifs() {
        return this.objectifs;
    }

    public String getPrerequis() {
        return this.prerequis;
    }

    public String getDebouches() {
        return this.debouches;
    }

    public String getEvaluationModalites() {
        return this.evaluationModalites;
    }

    public String getModaliteEnseignement() {
        return this.modaliteEnseignement;
    }

    public String getLieu() {
        return this.lieu;
    }

    public String getDateDebut() {
        return this.dateDebut;
    }

    public String getDateFin() {
        return this.dateFin;
    }

    public Integer getCapacite() {
        return this.capacite;
    }

    public Double getTarif() {
        return this.tarif;
    }

    public String getCertificationProfessionnelle() {
        return this.certificationProfessionnelle;
    }

    public Long getEtablissementId() {
        return this.etablissementId;
    }

    public String getEtablissementNom() {
        return this.etablissementNom;
    }

    public Long getUefrId() {
        return this.uefrId;
    }

    public String getUefrNom() {
        return this.uefrNom;
    }

    public Long getDepartementId() {
        return this.departementId;
    }

    public String getDepartementNom() {
        return this.departementNom;
    }

    public Integer getVolumeHoraireTotal() {
        return this.volumeHoraireTotal;
    }

    public Integer getEctsTotal() {
        return this.ectsTotal;
    }

    public List<CompetenceDetailDto> getCompetences() {
        return this.competences;
    }

    public List<UniteEnseignementDto> getUnitesEnseignement() {
        return this.unitesEnseignement;
    }

    public Long getResponsableId() {
        return this.responsableId;
    }

    public String getResponsableNom() {
        return this.responsableNom;
    }

    public LocalDateTime getDateCreation() {
        return this.dateCreation;
    }

    public Long getCreateurId() {
        return this.createurId;
    }

    public String getCreateurNom() {
        return this.createurNom;
    }

    public List<ElementConstitutifDto> getElementsConstitutifs() {
        return this.elementsConstitutifs;
    }
}

