/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.controller;

import com.moscepa.dto.MatiereInscriteDto;
import com.moscepa.dto.UserResponseDto;
import com.moscepa.security.UserPrincipal;
import com.moscepa.service.EtudiantService;
import com.moscepa.service.UserManagementService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/users"})
@CrossOrigin(origins={"*"})
public class UtilisateurController {
    @Autowired
    private EtudiantService etudiantService;
    @Autowired
    private UserManagementService userManagementService;

    @GetMapping(value={"/mes-inscriptions"})
    @PreAuthorize(value="hasRole('ETUDIANT')")
    public ResponseEntity<List<MatiereInscriteDto>> getMesInscriptions(Authentication authentication) {
        UserPrincipal userPrincipal = (UserPrincipal)authentication.getPrincipal();
        Long utilisateurId = userPrincipal.getId();
        List matieresInscrites = this.etudiantService.getMatieresInscrites(utilisateurId);
        return ResponseEntity.ok((Object)matieresInscrites);
    }

    @GetMapping(value={"/enseignants"})
    @PreAuthorize(value="hasRole('ADMIN')")
    public ResponseEntity<List<UserResponseDto>> getEnseignants() {
        List enseignants = this.userManagementService.getAllEnseignantsActifs();
        return ResponseEntity.ok((Object)enseignants);
    }
}

