/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.controller;

import com.moscepa.dto.UniteEnseignementDto;
import com.moscepa.service.UniteEnseignementService;
import jakarta.persistence.EntityNotFoundException;
import jakarta.validation.Valid;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/unites-enseignement"})
@CrossOrigin(origins={"*"})
public class UniteEnseignementController {
    @Autowired
    private UniteEnseignementService ueService;

    @GetMapping
    @PreAuthorize(value="isAuthenticated()")
    public ResponseEntity<List<UniteEnseignementDto>> getAllUe() {
        return ResponseEntity.ok((Object)this.ueService.findAll());
    }

    @GetMapping(value={"/{id}"})
    @PreAuthorize(value="isAuthenticated()")
    public ResponseEntity<UniteEnseignementDto> getUeById(@PathVariable Long id) {
        return this.ueService.findById(id).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @PostMapping
    @PreAuthorize(value="hasAnyAuthority('ROLE_ADMIN', 'ROLE_RESPONSABLE_FORMATION', 'ROLE_ENSEIGNANT')")
    public ResponseEntity<UniteEnseignementDto> createUe(@Valid @RequestBody UniteEnseignementDto ueDto) {
        UniteEnseignementDto savedDto = this.ueService.save(ueDto);
        return new ResponseEntity((Object)savedDto, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/{id}"})
    @PreAuthorize(value="hasAnyAuthority('ROLE_ADMIN', 'ROLE_RESPONSABLE_FORMATION', 'ROLE_ENSEIGNANT')")
    public ResponseEntity<UniteEnseignementDto> updateUe(@PathVariable Long id, @Valid @RequestBody UniteEnseignementDto ueDto) {
        try {
            return ResponseEntity.ok((Object)this.ueService.update(id, ueDto));
        }
        catch (EntityNotFoundException e) {
            return ResponseEntity.notFound().build();
        }
    }

    @DeleteMapping(value={"/{id}"})
    @PreAuthorize(value="hasAnyAuthority('ROLE_ADMIN', 'ROLE_RESPONSABLE_FORMATION', 'ROLE_ENSEIGNANT')")
    public ResponseEntity<Void> deleteUe(@PathVariable Long id) {
        try {
            this.ueService.deleteById(id);
            return ResponseEntity.noContent().build();
        }
        catch (EntityNotFoundException e) {
            return ResponseEntity.notFound().build();
        }
    }
}

