/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.controller;

import com.moscepa.dto.MatiereSyllabusDto;
import com.moscepa.security.UserPrincipal;
import com.moscepa.service.SyllabusService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/syllabus"})
@CrossOrigin(origins={"*"})
public class SyllabusController {
    @Autowired
    private SyllabusService syllabusService;

    @GetMapping(value={"/matiere/{ecId}"})
    @PreAuthorize(value="hasRole('ETUDIANT')")
    public ResponseEntity<MatiereSyllabusDto> getSyllabusPourMatiere(@PathVariable Long ecId, Authentication authentication) {
        UserPrincipal userPrincipal = (UserPrincipal)authentication.getPrincipal();
        Long utilisateurId = userPrincipal.getId();
        MatiereSyllabusDto syllabusDto = this.syllabusService.getSyllabusPourEtudiant(ecId, utilisateurId);
        return ResponseEntity.ok((Object)syllabusDto);
    }
}

