/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.controller;

import com.moscepa.dto.SectionDto;
import com.moscepa.dto.SectionUpdateRequest;
import com.moscepa.service.SectionService;
import jakarta.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/sections"})
public class SectionController {
    @Autowired
    private SectionService sectionService;

    @PutMapping(value={"/{id}"})
    @PreAuthorize(value="hasAnyAuthority('ROLE_ADMIN', 'ROLE_ENSEIGNANT', 'ROLE_RESPONSABLE_FORMATION')")
    public ResponseEntity<SectionDto> updateSection(@PathVariable Long id, @Valid @RequestBody SectionUpdateRequest updateRequest) {
        SectionDto updatedSection = this.sectionService.updateSectionContent(id, updateRequest);
        return ResponseEntity.ok((Object)updatedSection);
    }

    @DeleteMapping(value={"/{id}"})
    @PreAuthorize(value="hasAnyAuthority('ROLE_ADMIN', 'ROLE_ENSEIGNANT', 'ROLE_RESPONSABLE_FORMATION')")
    public ResponseEntity<Void> deleteSection(@PathVariable Long id) {
        this.sectionService.deleteSection(id);
        return ResponseEntity.noContent().build();
    }
}

