/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.controller;

import com.moscepa.dto.QuestionDto;
import com.moscepa.entity.Question;
import com.moscepa.service.QuestionService;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/questions"})
@CrossOrigin(origins={"*"}, maxAge=3600L)
public class QuestionController {
    @Autowired
    private QuestionService questionService;
    @PersistenceContext
    private EntityManager entityManager;

    @PostMapping
    public ResponseEntity<?> createQuestion(@RequestBody QuestionDto questionDto, @RequestParam(required=false) Long questionnaireId) {
        try {
            Question question;
            if (questionnaireId != null) {
                question = this.questionService.createQuestion(questionDto, questionnaireId);
            } else {
                Question newQuestion = new Question();
                newQuestion.setEnonce(questionDto.getEnonce());
                newQuestion.setPoints(questionDto.getPoints());
                newQuestion.setTypeQuestion(questionDto.getType());
                this.entityManager.persist((Object)newQuestion);
                question = newQuestion;
            }
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Question cr\u00e9\u00e9e avec succ\u00e8s");
            response.put("questionId", question.getId());
            response.put("question", new QuestionDto(question));
            return new ResponseEntity(response, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(Map.of("success", false, "message", "Erreur lors de la cr\u00e9ation: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<?> getQuestion(@PathVariable Long id) {
        try {
            QuestionDto questionDto = this.questionService.getQuestionById(id);
            HashMap<String, Boolean> response = new HashMap<String, Boolean>();
            response.put("success", true);
            response.put("question", (Boolean)questionDto);
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", false);
            response.put("message", e.getMessage());
            return new ResponseEntity(response, (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @GetMapping
    public ResponseEntity<?> getAllQuestions() {
        try {
            List questions = this.questionService.getAllQuestions();
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("questions", questions);
            response.put("count", questions.size());
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", false);
            response.put("message", "Erreur: " + e.getMessage());
            return new ResponseEntity(response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<?> updateQuestion(@PathVariable Long id, @RequestBody QuestionDto questionDto) {
        try {
            Question updatedQuestion = this.questionService.updateQuestion(id, questionDto);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Question mise \u00e0 jour avec succ\u00e8s");
            response.put("question", new QuestionDto(updatedQuestion));
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", false);
            response.put("message", "Erreur: " + e.getMessage());
            return new ResponseEntity(response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ResponseEntity<?> deleteQuestion(@PathVariable Long id) {
        return this.questionService.deleteQuestionFinal(id);
    }

    @DeleteMapping(value={"/alternative/{id}"})
    public ResponseEntity<?> deleteQuestionAlternative(@PathVariable Long id) {
        try {
            boolean deleted = this.questionService.deleteQuestionAlternative(id);
            HashMap<String, Object> response = new HashMap<String, Object>();
            if (deleted) {
                response.put("success", true);
                response.put("message", "Question supprim\u00e9e avec succ\u00e8s");
                return ResponseEntity.ok(response);
            }
            response.put("success", false);
            response.put("message", "Question non trouv\u00e9e");
            return new ResponseEntity(response, (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        catch (Exception e) {
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", false);
            response.put("message", "Erreur: " + e.getMessage());
            return new ResponseEntity(response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @DeleteMapping(value={"/direct/{id}"})
    @Transactional
    public ResponseEntity<?> deleteQuestionDirect(@PathVariable Long id) {
        try {
            this.entityManager.createNativeQuery("SET FOREIGN_KEY_CHECKS = 0").executeUpdate();
            int testRelations = this.entityManager.createNativeQuery("DELETE FROM moscepa_test_questions WHERE question_id = ?").setParameter(1, (Object)id).executeUpdate();
            int reponses = this.entityManager.createNativeQuery("DELETE FROM moscepa_reponses WHERE question_id = ?").setParameter(1, (Object)id).executeUpdate();
            int question = this.entityManager.createNativeQuery("DELETE FROM moscepa_questions WHERE id = ?").setParameter(1, (Object)id).executeUpdate();
            this.entityManager.createNativeQuery("SET FOREIGN_KEY_CHECKS = 1").executeUpdate();
            HashMap<String, Object> response = new HashMap<String, Object>();
            if (question > 0) {
                response.put("success", true);
                response.put("message", "Question supprim\u00e9e");
                response.put("deletedRelations", testRelations);
                response.put("deletedReponses", reponses);
                return ResponseEntity.ok(response);
            }
            response.put("success", false);
            response.put("message", "Question non trouv\u00e9e");
            return new ResponseEntity(response, (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        catch (Exception e) {
            try {
                this.entityManager.createNativeQuery("SET FOREIGN_KEY_CHECKS = 1").executeUpdate();
            }
            catch (Exception reponses) {
                // empty catch block
            }
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", false);
            response.put("message", "Erreur: " + e.getMessage());
            return new ResponseEntity(response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/questionnaire/{questionnaireId}"})
    public ResponseEntity<?> getQuestionsByQuestionnaire(@PathVariable Long questionnaireId) {
        try {
            List questions = this.questionService.getQuestionsByQuestionnaireId(questionnaireId);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("questions", questions);
            response.put("count", questions.size());
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", false);
            response.put("message", "Erreur: " + e.getMessage());
            return new ResponseEntity(response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/chapitre/{chapitreId}"})
    public ResponseEntity<?> getQuestionsByChapitre(@PathVariable Long chapitreId) {
        try {
            List questions = this.questionService.getQuestionsByChapitreId(chapitreId);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("questions", questions);
            response.put("count", questions.size());
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", false);
            response.put("message", "Erreur: " + e.getMessage());
            return new ResponseEntity(response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/matiere/{matiereId}"})
    public ResponseEntity<?> getQuestionsByMatiere(@PathVariable Long matiereId) {
        try {
            List questions = this.questionService.getQuestionsByMatiereId(matiereId);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("questions", questions);
            response.put("count", questions.size());
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", false);
            response.put("message", "Erreur: " + e.getMessage());
            return new ResponseEntity(response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/banque/{chapitreId}"})
    public ResponseEntity<?> getBanqueQuestions(@PathVariable Long chapitreId) {
        try {
            List questions = this.questionService.getBanqueQuestionsByChapitreId(chapitreId);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("questions", questions);
            response.put("count", questions.size());
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", false);
            response.put("message", "Erreur: " + e.getMessage());
            return new ResponseEntity(response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/debug/{id}"})
    public ResponseEntity<?> debugQuestion(@PathVariable Long id) {
        try {
            Map stats = this.questionService.getQuestionStats(id);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("id", id);
            response.put("stats", stats);
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", false);
            response.put("message", "Erreur: " + e.getMessage());
            return new ResponseEntity(response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @PostMapping(value={"/duplicate/{id}"})
    public ResponseEntity<?> duplicateQuestion(@PathVariable Long id) {
        try {
            Question duplicated = this.questionService.duplicateQuestion(id);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Question dupliqu\u00e9e avec succ\u00e8s");
            response.put("newQuestionId", duplicated.getId());
            response.put("question", new QuestionDto(duplicated));
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", false);
            response.put("message", "Erreur: " + e.getMessage());
            return new ResponseEntity(response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @PostMapping(value={"/{id}/change-questionnaire"})
    public ResponseEntity<?> changeQuestionnaire(@PathVariable Long id, @RequestParam Long newQuestionnaireId) {
        try {
            Question updated = this.questionService.changeQuestionnaire(id, newQuestionnaireId);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Question d\u00e9plac\u00e9e avec succ\u00e8s");
            response.put("question", new QuestionDto(updated));
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", false);
            response.put("message", "Erreur: " + e.getMessage());
            return new ResponseEntity(response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/stats"})
    public ResponseEntity<?> getStats() {
        try {
            long totalQuestions = this.questionService.countAllQuestions();
            HashMap<String, Comparable<Boolean>> response = new HashMap<String, Comparable<Boolean>>();
            response.put("success", Boolean.valueOf(true));
            response.put("totalQuestions", Long.valueOf(totalQuestions));
            response.put("timestamp", Long.valueOf(System.currentTimeMillis()));
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", false);
            response.put("message", "Erreur: " + e.getMessage());
            return new ResponseEntity(response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/search"})
    public ResponseEntity<?> searchQuestions(@RequestParam String q) {
        try {
            List results = this.questionService.searchQuestions(q);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("results", results);
            response.put("count", results.size());
            response.put("searchTerm", q);
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", false);
            response.put("message", "Erreur: " + e.getMessage());
            return new ResponseEntity(response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/type/{type}"})
    public ResponseEntity<?> getQuestionsByType(@PathVariable String type) {
        try {
            List questions = this.questionService.getQuestionsByType(type);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("questions", questions);
            response.put("count", questions.size());
            response.put("type", type);
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", false);
            response.put("message", "Erreur: " + e.getMessage());
            return new ResponseEntity(response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/exists/{id}"})
    public ResponseEntity<?> questionExists(@PathVariable Long id) {
        try {
            boolean exists = this.questionService.questionExists(id);
            HashMap<String, Comparable<Boolean>> response = new HashMap<String, Comparable<Boolean>>();
            response.put("success", Boolean.valueOf(true));
            response.put("exists", Boolean.valueOf(exists));
            response.put("id", id);
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", false);
            response.put("message", "Erreur: " + e.getMessage());
            return new ResponseEntity(response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/can-delete/{id}"})
    public ResponseEntity<?> canDeleteQuestion(@PathVariable Long id) {
        try {
            boolean canDelete = this.questionService.canDeleteQuestion(id);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("canDelete", canDelete);
            response.put("id", id);
            response.put("message", canDelete ? "La question peut \u00eatre supprim\u00e9e" : "La question est utilis\u00e9e dans des tests");
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", false);
            response.put("message", "Erreur: " + e.getMessage());
            return new ResponseEntity(response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/questionnaire/{questionnaireId}/count"})
    public ResponseEntity<?> countQuestionsInQuestionnaire(@PathVariable Long questionnaireId) {
        try {
            long count = this.questionService.countQuestionsInQuestionnaire(questionnaireId);
            HashMap<String, Comparable<Boolean>> response = new HashMap<String, Comparable<Boolean>>();
            response.put("success", Boolean.valueOf(true));
            response.put("count", Long.valueOf(count));
            response.put("questionnaireId", questionnaireId);
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", false);
            response.put("message", "Erreur: " + e.getMessage());
            return new ResponseEntity(response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/chapitre/{chapitreId}/count"})
    public ResponseEntity<?> countQuestionsInChapitre(@PathVariable Long chapitreId) {
        try {
            long count = this.questionService.countQuestionsInChapitre(chapitreId);
            HashMap<String, Comparable<Boolean>> response = new HashMap<String, Comparable<Boolean>>();
            response.put("success", Boolean.valueOf(true));
            response.put("count", Long.valueOf(count));
            response.put("chapitreId", chapitreId);
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", false);
            response.put("message", "Erreur: " + e.getMessage());
            return new ResponseEntity(response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/min-points/{minPoints}"})
    public ResponseEntity<?> getQuestionsWithMinPoints(@PathVariable double minPoints) {
        try {
            List questions = this.questionService.getQuestionsWithMinPoints(minPoints);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("questions", questions);
            response.put("count", questions.size());
            response.put("minPoints", minPoints);
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", false);
            response.put("message", "Erreur: " + e.getMessage());
            return new ResponseEntity(response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/health"})
    public ResponseEntity<?> healthCheck() {
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("status", "OK");
        response.put("service", "Question Service");
        response.put("timestamp", System.currentTimeMillis());
        response.put("version", "1.0.0");
        return ResponseEntity.ok(response);
    }
}

