/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.controller;

import com.moscepa.controller.MatiereController;
import com.moscepa.controller.MatiereDetailDto;
import com.moscepa.entity.Matiere;
import com.moscepa.repository.MatiereRepository;
import com.moscepa.service.MatiereService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/matieres"})
@CrossOrigin(origins={"*"})
@Tag(name="Mati\u00e8res", description="API de gestion des mati\u00e8res et de leurs d\u00e9tails")
public class MatiereController {
    @Autowired
    private MatiereService matiereService;
    @Autowired
    private MatiereRepository matiereRepository;

    @GetMapping(value={"", "/details"})
    @Operation(summary="R\u00e9cup\u00e9rer les d\u00e9tails de toutes les mati\u00e8res avec leurs chapitres")
    public ResponseEntity<List<MatiereDetailDto>> getAllMatiereDetails() {
        List dtos = this.matiereRepository.findAll().stream().map(arg_0 -> this.mapToMatiereDetailDto(arg_0)).collect(Collectors.toList());
        return ResponseEntity.ok(dtos);
    }

    @GetMapping(value={"/{id}"})
    @Operation(summary="R\u00e9cup\u00e9rer les d\u00e9tails complets d'une mati\u00e8re par son ID")
    public ResponseEntity<MatiereDetailDto> getMatiereDetailsById(@PathVariable Long id) {
        return this.matiereRepository.findById((Object)id).map(arg_0 -> this.mapToMatiereDetailDto(arg_0)).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @GetMapping(value={"/noms"})
    @Operation(summary="R\u00e9cup\u00e9rer les noms des mati\u00e8res disponibles")
    public ResponseEntity<List<String>> getMatieresDisponibles() {
        List nomsMatieres = this.matiereService.getMatieresDisponibles();
        return new ResponseEntity((Object)nomsMatieres, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping
    @Operation(summary="Cr\u00e9er une nouvelle mati\u00e8re")
    public ResponseEntity<?> createMatiere(@Valid @RequestBody CreateMatiereDto createMatiereDto) {
        if (this.matiereRepository.existsByNom(createMatiereDto.nom())) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body((Object)("Erreur : Une mati\u00e8re avec le nom '" + createMatiereDto.nom() + "' existe d\u00e9j\u00e0."));
        }
        Matiere nouvelleMatiere = new Matiere();
        nouvelleMatiere.setNom(createMatiereDto.nom());
        Matiere matiereSauvegardee = (Matiere)this.matiereRepository.save((Object)nouvelleMatiere);
        return new ResponseEntity((Object)matiereSauvegardee, (HttpStatusCode)HttpStatus.CREATED);
    }

    private MatiereDetailDto mapToMatiereDetailDto(Matiere matiere) {
        ArrayList chapitreDtos = new ArrayList();
        return new MatiereDetailDto(matiere.getId(), matiere.getNom(), matiere.getEc(), matiere.getOrdre(), matiere.getCoefficient(), chapitreDtos);
    }
}

