/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.controller;

import com.moscepa.service.FileStorageService;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api"})
public class FileUploadController {
    @Autowired
    private FileStorageService fileStorageService;

    @PostMapping(value={"/upload"})
    @PreAuthorize(value="hasAnyRole('ENSEIGNANT', 'ADMIN')")
    public ResponseEntity<?> uploadFile(@RequestParam(value="file") MultipartFile file) {
        String fileName = this.fileStorageService.storeFile(file);
        String filePath = "/uploads/" + fileName;
        return ResponseEntity.ok(Map.of("filePath", filePath));
    }
}

