/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.controller;

import com.moscepa.dto.EtablissementDTO;
import com.moscepa.service.EtablissementService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/etablissements"})
@Tag(name="\u00c9tablissements", description="API de gestion des \u00e9tablissements")
@CrossOrigin(origins={"http://localhost:4200"})
public class EtablissementController {
    private final EtablissementService etablissementService;

    @Autowired
    public EtablissementController(EtablissementService etablissementService) {
        this.etablissementService = etablissementService;
    }

    @GetMapping
    @Operation(summary="R\u00e9cup\u00e9rer tous les \u00e9tablissements")
    public ResponseEntity<List<EtablissementDTO>> getAllEtablissements() {
        List etablissements = this.etablissementService.getAllEtablissements();
        return ResponseEntity.ok((Object)etablissements);
    }

    @GetMapping(value={"/{id}"})
    @Operation(summary="R\u00e9cup\u00e9rer un \u00e9tablissement par son ID")
    public ResponseEntity<EtablissementDTO> getEtablissementById(@PathVariable Long id) {
        EtablissementDTO etablissement = this.etablissementService.getEtablissementById(id);
        return ResponseEntity.ok((Object)etablissement);
    }

    @PostMapping
    @Operation(summary="Cr\u00e9er un nouvel \u00e9tablissement")
    public ResponseEntity<EtablissementDTO> createEtablissement(@Valid @RequestBody EtablissementDTO etablissementDTO) {
        EtablissementDTO createdEtablissement = this.etablissementService.createEtablissement(etablissementDTO);
        return new ResponseEntity((Object)createdEtablissement, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/{id}"})
    @Operation(summary="Mettre \u00e0 jour un \u00e9tablissement")
    public ResponseEntity<EtablissementDTO> updateEtablissement(@PathVariable Long id, @Valid @RequestBody EtablissementDTO etablissementDTO) {
        EtablissementDTO updatedEtablissement = this.etablissementService.updateEtablissement(id, etablissementDTO);
        return ResponseEntity.ok((Object)updatedEtablissement);
    }

    @DeleteMapping(value={"/{id}"})
    @Operation(summary="Supprimer un \u00e9tablissement")
    public ResponseEntity<Void> deleteEtablissement(@PathVariable Long id) {
        this.etablissementService.deleteEtablissement(id);
        return ResponseEntity.noContent().build();
    }
}

