/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.controller;

import com.moscepa.dto.DepartementDTO;
import com.moscepa.entity.Departement;
import com.moscepa.service.DepartementService;
import jakarta.validation.Valid;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/departements"})
@CrossOrigin(origins={"*"})
public class DepartementController {
    @Autowired
    private DepartementService departementService;

    @GetMapping
    public ResponseEntity<List<DepartementDTO>> getAllDepartements() {
        try {
            List departements = this.departementService.getAllDepartements();
            List dtos = departements.stream().map(arg_0 -> this.convertToDTO(arg_0)).collect(Collectors.toList());
            return ResponseEntity.ok(dtos);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<DepartementDTO> getDepartementById(@PathVariable Long id) {
        try {
            Departement departement = this.departementService.getDepartementById(id);
            DepartementDTO dto = this.convertToDTO(departement);
            return ResponseEntity.ok((Object)dto);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build();
        }
    }

    @PostMapping
    public ResponseEntity<DepartementDTO> createDepartement(@Valid @RequestBody DepartementDTO departementDTO) {
        try {
            Departement departement = this.departementService.createDepartement(departementDTO);
            DepartementDTO responseDTO = this.convertToDTO(departement);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)responseDTO);
        }
        catch (RuntimeException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body(null);
        }
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<DepartementDTO> updateDepartement(@PathVariable Long id, @Valid @RequestBody DepartementDTO departementDTO) {
        try {
            Departement departement = this.departementService.updateDepartement(id, departementDTO);
            DepartementDTO responseDTO = this.convertToDTO(departement);
            return ResponseEntity.ok((Object)responseDTO);
        }
        catch (RuntimeException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body(null);
        }
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteDepartement(@PathVariable Long id) {
        try {
            this.departementService.deleteDepartement(id);
            return ResponseEntity.ok().build();
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build();
        }
    }

    @GetMapping(value={"/search"})
    public ResponseEntity<Map<String, Object>> search(@RequestParam(required=false) String search, @RequestParam(required=false) Long uefrId, @RequestParam(defaultValue="0") int page, @RequestParam(defaultValue="10") int size, @RequestParam(required=false) String sort) {
        try {
            PageRequest pageable;
            if (sort != null && sort.contains(",")) {
                String[] sortParams = sort.split(",");
                String sortField = sortParams[0];
                Sort.Direction direction = sortParams[1].equalsIgnoreCase("desc") ? Sort.Direction.DESC : Sort.Direction.ASC;
                pageable = PageRequest.of((int)page, (int)size, (Sort)Sort.by((Sort.Direction)direction, (String[])new String[]{sortField}));
            } else {
                pageable = PageRequest.of((int)page, (int)size);
            }
            Page departementsPage = this.departementService.search(search, uefrId, (Pageable)pageable);
            Page dtosPage = departementsPage.map(arg_0 -> this.convertToDTO(arg_0));
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("content", dtosPage.getContent());
            response.put("totalElements", departementsPage.getTotalElements());
            response.put("totalPages", departementsPage.getTotalPages());
            response.put("size", departementsPage.getSize());
            response.put("number", departementsPage.getNumber());
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            HashMap<String, CallSite> error = new HashMap<String, CallSite>();
            error.put("message", (CallSite)((Object)("Erreur lors de la recherche: " + e.getMessage())));
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(error);
        }
    }

    @GetMapping(value={"/exists/sigle/{sigle}"})
    public ResponseEntity<Map<String, Boolean>> checkSigleExists(@PathVariable String sigle) {
        try {
            boolean exists = this.departementService.existsBySigle(sigle);
            HashMap<String, Boolean> response = new HashMap<String, Boolean>();
            response.put("exists", exists);
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GetMapping(value={"/exists/sigle/{sigle}/not/{id}"})
    public ResponseEntity<Map<String, Boolean>> checkSigleExistsForOther(@PathVariable String sigle, @PathVariable Long id) {
        try {
            boolean exists = this.departementService.existsBySigleAndIdNot(sigle, id);
            HashMap<String, Boolean> response = new HashMap<String, Boolean>();
            response.put("exists", exists);
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private DepartementDTO convertToDTO(Departement departement) {
        DepartementDTO dto = new DepartementDTO();
        dto.setId(departement.getId());
        dto.setNom(departement.getNom());
        dto.setSigle(departement.getSigle());
        dto.setAdresse(departement.getAdresse());
        dto.setContact(departement.getContact());
        dto.setLogo(departement.getLogo());
        dto.setLien(departement.getLien());
        dto.setUefrId(departement.getUefr().getId());
        if (departement.getFormation() != null) {
            dto.setFormationId(departement.getFormation().getId());
        }
        dto.setCreatedAt(departement.getCreatedAt());
        dto.setUpdatedAt(departement.getUpdatedAt());
        return dto;
    }
}

