/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.controller;

import com.moscepa.dto.SectionCreateDto;
import com.moscepa.dto.SectionDto;
import com.moscepa.service.ChapitreService;
import com.moscepa.service.SectionService;
import jakarta.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/chapitres"})
public class ChapitreGestionController {
    @Autowired
    private ChapitreService chapitreService;
    @Autowired
    private SectionService sectionService;

    @DeleteMapping(value={"/{id}"})
    @PreAuthorize(value="hasAnyRole('ENSEIGNANT', 'ADMIN')")
    public ResponseEntity<Void> deleteChapitre(@PathVariable Long id) {
        this.chapitreService.deleteChapitre(id);
        return ResponseEntity.noContent().build();
    }

    @PostMapping(value={"/{chapitreId}/sections"})
    @PreAuthorize(value="hasAnyAuthority('ROLE_ADMIN', 'ROLE_ENSEIGNANT', 'ROLE_RESPONSABLE_FORMATION')")
    public ResponseEntity<SectionDto> createSection(@PathVariable Long chapitreId, @Valid @RequestBody SectionCreateDto sectionDto) {
        SectionDto createdSection = this.sectionService.createSection(chapitreId, sectionDto);
        return new ResponseEntity((Object)createdSection, (HttpStatusCode)HttpStatus.CREATED);
    }
}

