/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.controller;

import com.moscepa.dto.ChapitreAvecSectionsDto;
import com.moscepa.dto.ChapitreDetailDto;
import com.moscepa.dto.ChapitrePayload;
import com.moscepa.dto.QuestionDto;
import com.moscepa.service.ChapitreService;
import jakarta.validation.Valid;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/chapitres"})
public class ChapitreController {
    @Autowired
    private ChapitreService chapitreService;

    @GetMapping(value={"/search/complet"})
    @PreAuthorize(value="hasAnyAuthority('ROLE_ADMIN', 'ROLE_ENSEIGNANT', 'ROLE_RESPONSABLE_FORMATION')")
    public ResponseEntity<ChapitreAvecSectionsDto> findChapitreComplet(@RequestParam String matiere, @RequestParam Integer niveau) {
        return this.chapitreService.findChapitreCompletByMatiereAndNiveau(matiere, niveau).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @GetMapping(value={"/search"})
    @PreAuthorize(value="hasAnyAuthority('ROLE_ADMIN', 'ROLE_ENSEIGNANT', 'ROLE_RESPONSABLE_FORMATION')")
    public ResponseEntity<ChapitreDetailDto> findChapitreSimple(@RequestParam String matiere, @RequestParam Integer niveau) {
        return this.chapitreService.findByMatiereNomAndNiveau(matiere, niveau).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @GetMapping(value={"/{id}/details"})
    @PreAuthorize(value="isAuthenticated()")
    public ResponseEntity<ChapitreDetailDto> getChapitreDetailsPourTest(@PathVariable Long id) {
        ChapitreDetailDto dto = this.chapitreService.getChapitreDetailsPourTest(id);
        return ResponseEntity.ok((Object)dto);
    }

    @PostMapping
    @PreAuthorize(value="hasAnyAuthority('ROLE_ADMIN', 'ROLE_ENSEIGNANT', 'ROLE_RESPONSABLE_FORMATION')")
    public ResponseEntity<ChapitreDetailDto> createChapitreFromPayload(@Valid @RequestBody ChapitrePayload payload) {
        ChapitreDetailDto chapitreCree = this.chapitreService.creerChapitreAvecNomMatiere(payload);
        return new ResponseEntity((Object)chapitreCree, (HttpStatusCode)HttpStatus.CREATED);
    }

    @GetMapping(value={"/{chapitreId}/questions"})
    @PreAuthorize(value="hasAnyAuthority('ROLE_ADMIN', 'ROLE_ENSEIGNANT', 'ROLE_RESPONSABLE_FORMATION')")
    public ResponseEntity<List<QuestionDto>> getQuestionsPourChapitre(@PathVariable Long chapitreId) {
        List questions = this.chapitreService.getQuestionsPourChapitre(chapitreId);
        return ResponseEntity.ok((Object)questions);
    }

    @GetMapping(value={"/{id}"})
    @PreAuthorize(value="hasAnyAuthority('ROLE_ADMIN', 'ROLE_ENSEIGNANT', 'ROLE_RESPONSABLE_FORMATION')")
    public ResponseEntity<ChapitreDetailDto> getChapitreById(@PathVariable Long id) {
        return this.chapitreService.getChapitreDetailsById(id).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @GetMapping(value={"/{id}/details-complets"})
    @PreAuthorize(value="isAuthenticated()")
    public ResponseEntity<ChapitreAvecSectionsDto> getChapitreCompletById(@PathVariable Long id) {
        return this.chapitreService.findChapitreCompletById(id).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }
}

