/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.controller;

import com.moscepa.dto.BanqueQuestionCreationDto;
import com.moscepa.dto.BanqueQuestionDetailDto;
import com.moscepa.service.BanqueQuestionService;
import jakarta.validation.Valid;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/banque-questions"})
@CrossOrigin(origins={"http://localhost:4200"})
public class BanqueQuestionController {
    private final BanqueQuestionService banqueQuestionService;

    public BanqueQuestionController(BanqueQuestionService banqueQuestionService) {
        this.banqueQuestionService = banqueQuestionService;
    }

    @PostMapping
    @PreAuthorize(value="hasAnyRole('ENSEIGNANT', 'ADMIN')")
    public ResponseEntity<BanqueQuestionDetailDto> creerQuestion(@Valid @RequestBody BanqueQuestionCreationDto dto) {
        BanqueQuestionDetailDto nouvelleQuestion = this.banqueQuestionService.creerQuestion(dto);
        return new ResponseEntity((Object)nouvelleQuestion, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/{id}"})
    @PreAuthorize(value="hasAnyRole('ENSEIGNANT', 'ADMIN')")
    public ResponseEntity<BanqueQuestionDetailDto> mettreAJourQuestion(@PathVariable Long id, @Valid @RequestBody BanqueQuestionCreationDto dto) {
        BanqueQuestionDetailDto questionMiseAJour = this.banqueQuestionService.mettreAJourQuestion(id, dto);
        return ResponseEntity.ok((Object)questionMiseAJour);
    }

    @GetMapping
    @PreAuthorize(value="hasAnyRole('ENSEIGNANT', 'ADMIN')")
    public ResponseEntity<List<BanqueQuestionDetailDto>> getAllQuestions() {
        List questions = this.banqueQuestionService.getAllQuestions();
        return ResponseEntity.ok((Object)questions);
    }

    @GetMapping(value={"/{id}"})
    @PreAuthorize(value="hasAnyRole('ENSEIGNANT', 'ADMIN')")
    public ResponseEntity<BanqueQuestionDetailDto> getQuestionById(@PathVariable Long id) {
        BanqueQuestionDetailDto question = this.banqueQuestionService.getQuestionById(id);
        return ResponseEntity.ok((Object)question);
    }

    @DeleteMapping(value={"/{id}"})
    @PreAuthorize(value="hasAnyRole('ENSEIGNANT', 'ADMIN')")
    public ResponseEntity<Void> supprimerQuestion(@PathVariable Long id) {
        this.banqueQuestionService.supprimerQuestion(id);
        return ResponseEntity.noContent().build();
    }
}

