/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.controller;

import com.moscepa.dto.LoginRequest;
import com.moscepa.dto.LoginResponse;
import com.moscepa.entity.Utilisateur;
import com.moscepa.service.AuthService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/auth"})
@CrossOrigin(origins={"*"})
@Tag(name="Authentification", description="API d'authentification et de gestion des sessions")
public class AuthController {
    @Autowired
    private AuthService authService;

    @PostMapping(value={"/login"})
    @Operation(summary="Connexion utilisateur", description="Authentifie un utilisateur avec email et mot de passe")
    public ResponseEntity<?> authenticateUser(@Valid @RequestBody LoginRequest loginRequest) {
        try {
            LoginResponse loginResponse = this.authService.authenticateUser(loginRequest);
            return ResponseEntity.ok((Object)loginResponse);
        }
        catch (Exception e) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("message", "Email ou mot de passe incorrect");
            error.put("error", "INVALID_CREDENTIALS");
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body(error);
        }
    }

    @PostMapping(value={"/logout"})
    @Operation(summary="D\u00e9connexion utilisateur", description="D\u00e9connecte l'utilisateur actuel")
    public ResponseEntity<?> logoutUser() {
        SecurityContextHolder.clearContext();
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("message", "D\u00e9connexion r\u00e9ussie");
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/me"})
    @Operation(summary="Profil utilisateur", description="R\u00e9cup\u00e8re les informations de l'utilisateur connect\u00e9")
    public ResponseEntity<?> getCurrentUser() {
        try {
            Utilisateur currentUser = this.authService.getCurrentUser();
            HashMap<String, Object> userInfo = new HashMap<String, Object>();
            userInfo.put("id", currentUser.getId());
            userInfo.put("email", currentUser.getEmail());
            userInfo.put("nom", currentUser.getNom());
            userInfo.put("prenom", currentUser.getPrenom());
            userInfo.put("role", currentUser.getRole());
            userInfo.put("actif", currentUser.getActif());
            return ResponseEntity.ok(userInfo);
        }
        catch (Exception e) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("message", "Utilisateur non authentifi\u00e9");
            error.put("error", "NOT_AUTHENTICATED");
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body(error);
        }
    }

    @GetMapping(value={"/check"})
    @Operation(summary="V\u00e9rifier l'authentification", description="V\u00e9rifie si l'utilisateur est connect\u00e9")
    public ResponseEntity<?> checkAuthentication() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        HashMap<String, Object> response = new HashMap<String, Object>();
        if (authentication != null && authentication.isAuthenticated() && !authentication.getName().equals("anonymousUser")) {
            response.put("authenticated", true);
            response.put("username", authentication.getName());
        } else {
            response.put("authenticated", false);
        }
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/check-email"})
    @Operation(summary="V\u00e9rifier l'existence d'un email", description="V\u00e9rifie si un email est d\u00e9j\u00e0 utilis\u00e9")
    public ResponseEntity<?> checkEmailExists(@RequestParam String email) {
        HashMap<String, Boolean> response = new HashMap<String, Boolean>();
        response.put("exists", this.authService.existsByEmail(email));
        return ResponseEntity.ok(response);
    }
}

