/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.controller;

import com.moscepa.dto.ChapitreDto;
import com.moscepa.dto.ElementConstitutifRequestDto;
import com.moscepa.dto.ElementConstitutifResponseDto;
import com.moscepa.security.UserPrincipal;
import com.moscepa.service.ElementConstitutifService;
import jakarta.validation.Valid;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class AllElementsConstitutifsController {
    @Autowired
    private ElementConstitutifService elementConstitutifService;

    @GetMapping(value={"/elements-constitutifs/mes-matieres"})
    @PreAuthorize(value="hasAnyAuthority('ROLE_ENSEIGNANT', 'ROLE_ADMIN', 'ROLE_RESPONSABLE_FORMATION','ROLE_ETUDIANT')")
    public ResponseEntity<List<ElementConstitutifResponseDto>> getMesMatieres(Authentication authentication) {
        List dtos;
        System.out.println("\n\n================== D\u00c9BUT DU TRA\u00c7AGE ==================");
        UserPrincipal userPrincipal = (UserPrincipal)authentication.getPrincipal();
        Long utilisateurId = userPrincipal.getId();
        String roles = userPrincipal.getAuthorities().stream().map(auth -> auth.getAuthority()).collect(Collectors.joining(", "));
        System.out.println("[CONTROLLER] Requ\u00eate re\u00e7ue pour /mes-matieres.");
        System.out.println("[CONTROLLER] Utilisateur ID: " + utilisateurId);
        System.out.println("[CONTROLLER] Utilisateur Email: " + userPrincipal.getEmail());
        System.out.println("[CONTROLLER] R\u00f4les de l'utilisateur: [" + roles + "]");
        if (userPrincipal.getAuthorities().stream().anyMatch(a -> a.getAuthority().equals("ROLE_ADMIN")) || userPrincipal.getAuthorities().stream().anyMatch(a -> a.getAuthority().equals("ROLE_RESPONSABLE_FORMATION"))) {
            System.out.println("[CONTROLLER] R\u00f4le ADMIN/RESPONSABLE d\u00e9tect\u00e9. Appel de findAll().");
            dtos = this.elementConstitutifService.findAll();
            System.out.println("[CONTROLLER] Le service (findAll) a retourn\u00e9 " + dtos.size() + " mati\u00e8re(s).");
        } else if (userPrincipal.getAuthorities().stream().anyMatch(a -> a.getAuthority().equals("ROLE_ENSEIGNANT"))) {
            System.out.println("[CONTROLLER] R\u00f4le ENSEIGNANT d\u00e9tect\u00e9. Appel de findByEnseignantId(" + utilisateurId + ").");
            dtos = this.elementConstitutifService.findByEnseignantId(utilisateurId);
            System.out.println("[CONTROLLER] Le service (findByEnseignantId) a retourn\u00e9 " + dtos.size() + " mati\u00e8re(s).");
        } else if (userPrincipal.getAuthorities().stream().anyMatch(a -> a.getAuthority().equals("ROLE_ETUDIANT"))) {
            System.out.println("[CONTROLLER] R\u00f4le ETUDIANT d\u00e9tect\u00e9. Appel de findMatieresByEtudiantId(" + utilisateurId + ").");
            dtos = this.elementConstitutifService.findMatieresByEtudiantId(utilisateurId);
            System.out.println("[CONTROLLER] Le service (findMatieresByEtudiantId) a retourn\u00e9 " + dtos.size() + " mati\u00e8re(s).");
        } else {
            System.out.println("[CONTROLLER] Aucun r\u00f4le g\u00e9r\u00e9 trouv\u00e9. Renvoi d'une liste vide.");
            dtos = List.of();
        }
        System.out.println("[CONTROLLER] Envoi de la r\u00e9ponse au frontend.");
        System.out.println("================== FIN DU TRA\u00c7AGE ==================\n\n");
        return ResponseEntity.ok((Object)dtos);
    }

    @GetMapping(value={"/elements-constitutifs"})
    @PreAuthorize(value="hasAnyAuthority('ROLE_ADMIN', 'ROLE_RESPONSABLE_FORMATION', 'ROLE_ENSEIGNANT')")
    public ResponseEntity<List<ElementConstitutifResponseDto>> getAllElementsConstitutifs() {
        List dtos = this.elementConstitutifService.findAll();
        return ResponseEntity.ok((Object)dtos);
    }

    @GetMapping(value={"/elements-constitutifs/details"})
    @PreAuthorize(value="isAuthenticated()")
    public ResponseEntity<List<ElementConstitutifResponseDto>> getElementsConstitutifsAvecDetails() {
        List dtos = this.elementConstitutifService.findAllWithChapitres();
        return ResponseEntity.ok((Object)dtos);
    }

    @GetMapping(value={"/elements-constitutifs/noms"})
    @PreAuthorize(value="hasAnyAuthority('ROLE_ENSEIGNANT','ROLE_ADMIN')")
    public ResponseEntity<List<String>> getAllElementNoms() {
        List noms = this.elementConstitutifService.findAllNoms();
        return ResponseEntity.ok((Object)noms);
    }

    @PostMapping(value={"/unites-enseignement/{ueId}/elements-constitutifs"})
    @PreAuthorize(value="hasAnyAuthority('ROLE_ADMIN', 'ROLE_ENSEIGNANT', 'ROLE_RESPONSABLE_FORMATION')")
    public ResponseEntity<ElementConstitutifResponseDto> createElementConstitutif(@PathVariable Long ueId, @Valid @RequestBody ElementConstitutifRequestDto requestDto) {
        ElementConstitutifResponseDto createdDto = this.elementConstitutifService.create(ueId, requestDto);
        return new ResponseEntity((Object)createdDto, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/elements-constitutifs/{id}"})
    @PreAuthorize(value="hasAnyAuthority('ROLE_ADMIN', 'ROLE_RESPONSABLE_FORMATION', 'ROLE_ENSEIGNANT')")
    public ResponseEntity<ElementConstitutifResponseDto> updateElementConstitutif(@PathVariable Long id, @Valid @RequestBody ElementConstitutifRequestDto dto) {
        ElementConstitutifResponseDto updatedDto = this.elementConstitutifService.update(id, dto);
        return ResponseEntity.ok((Object)updatedDto);
    }

    @DeleteMapping(value={"/elements-constitutifs/{id}"})
    @PreAuthorize(value="hasAnyAuthority('ROLE_ADMIN', 'ROLE_RESPONSABLE_FORMATION', 'ROLE_ENSEIGNANT')")
    public ResponseEntity<Void> deleteElementConstitutif(@PathVariable Long id) {
        this.elementConstitutifService.deleteById(id);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/elements-constitutifs/{ecId}/chapitres"})
    @PreAuthorize(value="isAuthenticated()")
    public ResponseEntity<List<ChapitreDto>> getChapitresParElementConstitutif(@PathVariable Long ecId) {
        List chapitres = this.elementConstitutifService.findChapitresByEcId(ecId);
        return ResponseEntity.ok((Object)chapitres);
    }
}

