/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.service;

import com.moscepa.dto.UserRegistrationDto;
import com.moscepa.dto.UserResponseDto;
import com.moscepa.entity.Role;
import com.moscepa.entity.Utilisateur;
import com.moscepa.repository.UtilisateurRepository;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.modelmapper.ModelMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class UserManagementService {
    @Autowired
    private UtilisateurRepository utilisateurRepository;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private ModelMapper modelMapper;

    public UserResponseDto updateUser(Long id, UserRegistrationDto userRegistrationDto) {
        Utilisateur utilisateur = (Utilisateur)this.utilisateurRepository.findById((Object)id).orElseThrow(() -> new RuntimeException("Utilisateur non trouv\u00e9 avec l'ID: " + id));
        if (!utilisateur.getEmail().equals(userRegistrationDto.getEmail()) && this.utilisateurRepository.existsByEmail(userRegistrationDto.getEmail())) {
            throw new RuntimeException("Un utilisateur avec cet email existe d\u00e9j\u00e0");
        }
        utilisateur.setNom(userRegistrationDto.getNom());
        utilisateur.setPrenom(userRegistrationDto.getPrenom());
        utilisateur.setEmail(userRegistrationDto.getEmail());
        utilisateur.setActif(Boolean.valueOf(userRegistrationDto.getActif() != null ? userRegistrationDto.getActif() : true));
        if (userRegistrationDto.getRole() != null) {
            utilisateur.setRole(userRegistrationDto.getRole());
        }
        if (userRegistrationDto.getMotDePasse() != null && !userRegistrationDto.getMotDePasse().isEmpty()) {
            utilisateur.setMotDePasse(this.passwordEncoder.encode((CharSequence)userRegistrationDto.getMotDePasse()));
        }
        Utilisateur updatedUser = (Utilisateur)this.utilisateurRepository.save((Object)utilisateur);
        return this.convertToUserResponseDto(updatedUser);
    }

    public UserResponseDto createUser(UserRegistrationDto userRegistrationDto) {
        if (this.utilisateurRepository.existsByEmail(userRegistrationDto.getEmail())) {
            throw new RuntimeException("Un utilisateur avec cet email existe d\u00e9j\u00e0");
        }
        Utilisateur utilisateur = new Utilisateur();
        utilisateur.setNom(userRegistrationDto.getNom());
        utilisateur.setPrenom(userRegistrationDto.getPrenom());
        utilisateur.setEmail(userRegistrationDto.getEmail());
        utilisateur.setMotDePasse(this.passwordEncoder.encode((CharSequence)userRegistrationDto.getMotDePasse()));
        utilisateur.setRole(userRegistrationDto.getRole());
        utilisateur.setActif(Boolean.valueOf(userRegistrationDto.getActif() != null ? userRegistrationDto.getActif() : true));
        Utilisateur savedUser = (Utilisateur)this.utilisateurRepository.save((Object)utilisateur);
        return this.convertToUserResponseDto(savedUser);
    }

    public List<UserResponseDto> getAllUsers() {
        return this.utilisateurRepository.findAllByOrderByDateCreationDesc().stream().map(arg_0 -> this.convertToUserResponseDto(arg_0)).collect(Collectors.toList());
    }

    public Optional<UserResponseDto> getUserById(Long id) {
        return this.utilisateurRepository.findById((Object)id).map(arg_0 -> this.convertToUserResponseDto(arg_0));
    }

    public List<UserResponseDto> getUsersByRole(Role role) {
        return this.utilisateurRepository.findByRoleOrderByNomAscPrenomAsc(role).stream().map(arg_0 -> this.convertToUserResponseDto(arg_0)).collect(Collectors.toList());
    }

    public void deactivateUser(Long id) {
        Utilisateur utilisateur = (Utilisateur)this.utilisateurRepository.findById((Object)id).orElseThrow(() -> new RuntimeException("Utilisateur non trouv\u00e9"));
        utilisateur.setActif(Boolean.valueOf(false));
        this.utilisateurRepository.save((Object)utilisateur);
    }

    public void activateUser(Long id) {
        Utilisateur utilisateur = (Utilisateur)this.utilisateurRepository.findById((Object)id).orElseThrow(() -> new RuntimeException("Utilisateur non trouv\u00e9"));
        utilisateur.setActif(Boolean.valueOf(true));
        this.utilisateurRepository.save((Object)utilisateur);
    }

    public void deleteUser(Long id) {
        if (!this.utilisateurRepository.existsById((Object)id)) {
            throw new RuntimeException("Utilisateur non trouv\u00e9");
        }
        this.utilisateurRepository.deleteById((Object)id);
    }

    public List<UserResponseDto> searchUsers(String searchTerm) {
        return this.utilisateurRepository.findByNomOrPrenomContainingIgnoreCase(searchTerm).stream().map(arg_0 -> this.convertToUserResponseDto(arg_0)).collect(Collectors.toList());
    }

    public long countUsersByRole(Role role) {
        return this.utilisateurRepository.countByRole(role);
    }

    public boolean emailExists(String email) {
        return this.utilisateurRepository.existsByEmail(email);
    }

    public List<UserResponseDto> getAllEnseignantsActifs() {
        return this.utilisateurRepository.findAllEnseignantsActifs().stream().map(arg_0 -> this.convertToUserResponseDto(arg_0)).collect(Collectors.toList());
    }

    private UserResponseDto convertToUserResponseDto(Utilisateur utilisateur) {
        return (UserResponseDto)this.modelMapper.map((Object)utilisateur, UserResponseDto.class);
    }
}

