/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.service;

import com.moscepa.dto.UefrDTO;
import com.moscepa.entity.Etablissement;
import com.moscepa.entity.Uefr;
import com.moscepa.exception.ResourceNotFoundException;
import com.moscepa.repository.EtablissementRepository;
import com.moscepa.repository.UefrRepository;
import java.util.List;
import java.util.stream.Collectors;
import org.modelmapper.ModelMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class UefrService {
    private final UefrRepository uefrRepository;
    private final EtablissementRepository etablissementRepository;
    private final ModelMapper modelMapper;

    @Autowired
    public UefrService(UefrRepository uefrRepository, EtablissementRepository etablissementRepository, ModelMapper modelMapper) {
        this.uefrRepository = uefrRepository;
        this.etablissementRepository = etablissementRepository;
        this.modelMapper = modelMapper;
    }

    public List<UefrDTO> getAllUefrs() {
        return this.uefrRepository.findAll().stream().map(arg_0 -> this.convertToDTO(arg_0)).collect(Collectors.toList());
    }

    public UefrDTO getUefrById(Long id) {
        Uefr uefr = (Uefr)this.uefrRepository.findById((Object)id).orElseThrow(() -> new ResourceNotFoundException("UEFR non trouv\u00e9 avec l'ID : " + id));
        return this.convertToDTO(uefr);
    }

    public UefrDTO createUefr(UefrDTO uefrDTO) {
        Etablissement etablissement = (Etablissement)this.etablissementRepository.findById((Object)uefrDTO.getEtablissementId()).orElseThrow(() -> new ResourceNotFoundException("\u00c9tablissement non trouv\u00e9 avec l'ID : " + uefrDTO.getEtablissementId()));
        if (this.uefrRepository.existsBySigle(uefrDTO.getSigle())) {
            throw new IllegalArgumentException("Une UEFR avec ce sigle existe d\u00e9j\u00e0");
        }
        Uefr uefr = this.convertToEntity(uefrDTO);
        uefr.setEtablissement(etablissement);
        Uefr savedUefr = (Uefr)this.uefrRepository.save((Object)uefr);
        return this.convertToDTO(savedUefr);
    }

    public UefrDTO updateUefr(Long id, UefrDTO uefrDTO) {
        Uefr existingUefr = (Uefr)this.uefrRepository.findById((Object)id).orElseThrow(() -> new ResourceNotFoundException("UEFR non trouv\u00e9 avec l'ID : " + id));
        Etablissement etablissement = (Etablissement)this.etablissementRepository.findById((Object)uefrDTO.getEtablissementId()).orElseThrow(() -> new ResourceNotFoundException("\u00c9tablissement non trouv\u00e9 avec l'ID : " + uefrDTO.getEtablissementId()));
        if (!existingUefr.getSigle().equals(uefrDTO.getSigle()) && this.uefrRepository.existsBySigleAndIdNot(uefrDTO.getSigle(), id)) {
            throw new IllegalArgumentException("Une UEFR avec ce sigle existe d\u00e9j\u00e0");
        }
        existingUefr.setNom(uefrDTO.getNom());
        existingUefr.setSigle(uefrDTO.getSigle());
        existingUefr.setAdresse(uefrDTO.getAdresse());
        existingUefr.setContact(uefrDTO.getContact());
        existingUefr.setLogo(uefrDTO.getLogo());
        existingUefr.setLien(uefrDTO.getLien());
        existingUefr.setEtablissement(etablissement);
        Uefr updatedUefr = (Uefr)this.uefrRepository.save((Object)existingUefr);
        return this.convertToDTO(updatedUefr);
    }

    public void deleteUefr(Long id) {
        if (!this.uefrRepository.existsById((Object)id)) {
            throw new ResourceNotFoundException("UEFR non trouv\u00e9 avec l'ID : " + id);
        }
        this.uefrRepository.deleteById((Object)id);
    }

    public List<UefrDTO> getUefrsByEtablissementId(Long etablissementId) {
        return this.uefrRepository.findByEtablissementId(etablissementId).stream().map(arg_0 -> this.convertToDTO(arg_0)).collect(Collectors.toList());
    }

    private UefrDTO convertToDTO(Uefr uefr) {
        UefrDTO dto = new UefrDTO();
        dto.setId(uefr.getId());
        dto.setNom(uefr.getNom());
        dto.setSigle(uefr.getSigle());
        dto.setAdresse(uefr.getAdresse());
        dto.setContact(uefr.getContact());
        dto.setLogo(uefr.getLogo());
        dto.setLien(uefr.getLien());
        dto.setEtablissementId(uefr.getEtablissement().getId());
        dto.setCreatedAt(uefr.getCreatedAt());
        dto.setUpdatedAt(uefr.getUpdatedAt());
        return dto;
    }

    private Uefr convertToEntity(UefrDTO uefrDTO) {
        Uefr uefr = new Uefr();
        uefr.setNom(uefrDTO.getNom());
        uefr.setSigle(uefrDTO.getSigle());
        uefr.setAdresse(uefrDTO.getAdresse());
        uefr.setContact(uefrDTO.getContact());
        uefr.setLogo(uefrDTO.getLogo());
        uefr.setLien(uefrDTO.getLien());
        return uefr;
    }
}

