/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.service;

import com.moscepa.entity.Inscription;
import com.moscepa.entity.Utilisateur;
import com.moscepa.repository.InscriptionRepository;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TuteurService {
    @Autowired
    private InscriptionRepository inscriptionRepository;

    public List<Utilisateur> getMesEtudiants(Long tuteurId) {
        return this.inscriptionRepository.findEtudiantsByTuteur(tuteurId);
    }

    @Transactional
    public void validerEtudiant(Long inscriptionId) {
        Optional inscriptionOpt = this.inscriptionRepository.findById((Object)inscriptionId);
        if (!inscriptionOpt.isPresent()) {
            throw new RuntimeException("Inscription avec l'ID " + inscriptionId + " introuvable.");
        }
        Inscription ins = (Inscription)inscriptionOpt.get();
        ins.setStatut("VALIDE");
        ins.setDateValidation(LocalDateTime.now());
        this.inscriptionRepository.save((Object)ins);
    }
}

