/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.service;

import com.moscepa.dto.ChapitreRecommandationDto;
import com.moscepa.dto.HistoriqueResultatDto;
import com.moscepa.dto.QuestionDiagnosticDto;
import com.moscepa.dto.QuestionDto;
import com.moscepa.dto.ReponsePourQuestionDto;
import com.moscepa.dto.ReponseSoumiseDto;
import com.moscepa.dto.ResultatDiagnosticDto;
import com.moscepa.dto.ResultatTestDto;
import com.moscepa.dto.SoumissionTestDto;
import com.moscepa.entity.Chapitre;
import com.moscepa.entity.Question;
import com.moscepa.entity.Questionnaire;
import com.moscepa.entity.Reponse;
import com.moscepa.entity.ResultatTest;
import com.moscepa.entity.Test;
import com.moscepa.entity.TypeQuestion;
import com.moscepa.entity.Utilisateur;
import com.moscepa.repository.ChapitreRepository;
import com.moscepa.repository.QuestionRepository;
import com.moscepa.repository.QuestionnaireRepository;
import com.moscepa.repository.ResultatTestRepository;
import com.moscepa.repository.TestRepository;
import com.moscepa.repository.UtilisateurRepository;
import com.moscepa.security.UserPrincipal;
import com.moscepa.service.TestService;
import jakarta.persistence.EntityNotFoundException;
import java.text.Normalizer;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class TestService {
    private final TestRepository testRepository;
    private final QuestionRepository questionRepository;
    private final ResultatTestRepository resultatTestRepository;
    private final UtilisateurRepository utilisateurRepository;
    private final ChapitreRepository chapitreRepository;
    private final QuestionnaireRepository questionnaireRepository;

    public TestService(TestRepository testRepository, QuestionRepository questionRepository, ResultatTestRepository resultatTestRepository, UtilisateurRepository utilisateurRepository, ChapitreRepository chapitreRepository, QuestionnaireRepository questionnaireRepository) {
        this.testRepository = testRepository;
        this.questionRepository = questionRepository;
        this.resultatTestRepository = resultatTestRepository;
        this.utilisateurRepository = utilisateurRepository;
        this.chapitreRepository = chapitreRepository;
        this.questionnaireRepository = questionnaireRepository;
    }

    @Transactional
    public Test creerTestAvecQuestions(Long chapitreId, String titre, List<Long> questionIds) {
        Chapitre chapitre = (Chapitre)this.chapitreRepository.findById((Object)chapitreId).orElseThrow(() -> new EntityNotFoundException("Chapitre non trouv\u00e9 avec l'ID: " + chapitreId));
        List questions = this.questionRepository.findAllById(questionIds);
        if (questions.size() != questionIds.size()) {
            throw new EntityNotFoundException("Une ou plusieurs questions n'ont pas \u00e9t\u00e9 trouv\u00e9es.");
        }
        Test test = new Test();
        test.setTitre(titre);
        test.setChapitre(chapitre);
        test.setQuestions(questions);
        return (Test)this.testRepository.save((Object)test);
    }

    @Transactional
    public Test creerTestDepuisQuestionnaire(Long questionnaireId) {
        Questionnaire questionnaire = (Questionnaire)this.questionnaireRepository.findById((Object)questionnaireId).orElseThrow(() -> new EntityNotFoundException("Questionnaire non trouv\u00e9 avec l'ID: " + questionnaireId));
        if (questionnaire.getChapitre() == null) {
            throw new IllegalStateException("Impossible de cr\u00e9er un test : le questionnaire n'a pas de chapitre.");
        }
        if (questionnaire.getQuestions().isEmpty()) {
            throw new EntityNotFoundException("Le questionnaire ne contient aucune question.");
        }
        Test test = new Test();
        test.setTitre("Test pour " + questionnaire.getTitre());
        test.setChapitre(questionnaire.getChapitre());
        test.setQuestionnaire(questionnaire);
        test.setQuestions(new ArrayList(questionnaire.getQuestions()));
        questionnaire.addTest(test);
        return (Test)this.testRepository.save((Object)test);
    }

    public List<QuestionDto> getQuestionsPourChapitre(Long chapitreId) {
        return this.testRepository.findTopByChapitreId(chapitreId).map(test -> test.getQuestions().stream().map(QuestionDto::new).collect(Collectors.toList())).orElse(new ArrayList());
    }

    @Transactional
    public ResultatTestDto calculerEtSauvegarderResultat(Long chapitreId, Long utilisateurId, Map<String, Object> reponsesUtilisateur) {
        Utilisateur etudiant = (Utilisateur)this.utilisateurRepository.findById((Object)utilisateurId).orElseThrow(() -> new EntityNotFoundException("Utilisateur non trouv\u00e9 avec l'ID: " + utilisateurId));
        Test test = (Test)this.testRepository.findTopByChapitreId(chapitreId).orElseThrow(() -> new EntityNotFoundException("Aucun test trouv\u00e9 pour le chapitre ID: " + chapitreId));
        double scoreObtenu = 0.0;
        double totalPoints = 0.0;
        int bonnesReponses = 0;
        for (Question question : test.getQuestions()) {
            totalPoints += question.getPoints();
            Object reponse = reponsesUtilisateur.get(String.valueOf(question.getId()));
            boolean estCorrect = this.verifierReponse(question, reponse);
            if (!estCorrect) continue;
            scoreObtenu += question.getPoints();
            ++bonnesReponses;
        }
        ResultatTest resultat = new ResultatTest();
        resultat.setEtudiant(etudiant);
        resultat.setTest(test);
        resultat.setScore(Double.valueOf(scoreObtenu));
        resultat.setScoreTotal(Double.valueOf(totalPoints));
        resultat.setBonnesReponses(bonnesReponses);
        resultat.setTotalQuestions(test.getQuestions().size());
        resultat.setDateTest(LocalDateTime.now());
        this.resultatTestRepository.save((Object)resultat);
        ResultatTestDto dto = new ResultatTestDto();
        dto.setChapitreId(chapitreId);
        dto.setScoreObtenu(scoreObtenu);
        dto.setTotalPointsPossible(totalPoints);
        dto.setDateSoumission(LocalDateTime.now());
        return dto;
    }

    public List<HistoriqueResultatDto> getHistoriquePourEtudiant(Long utilisateurId) {
        List resultats = this.resultatTestRepository.findByEtudiantIdOrderByDateTestDesc(utilisateurId);
        return resultats.stream().map(HistoriqueResultatDto::new).collect(Collectors.toList());
    }

    private String normaliser(String str) {
        if (str == null) {
            return "";
        }
        String nfdNormalizedString = Normalizer.normalize(str, Normalizer.Form.NFD);
        Pattern pattern = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
        return pattern.matcher(nfdNormalizedString).replaceAll("").trim().toLowerCase();
    }

    private boolean verifierReponse(Question question, Object reponseDonnee) {
        if (reponseDonnee == null) {
            return false;
        }
        String inputBrut = reponseDonnee.toString().trim();
        if (question.getTypeQuestion() == TypeQuestion.VRAI_FAUX) {
            if (inputBrut.equalsIgnoreCase("true")) {
                inputBrut = "Vrai";
            }
            if (inputBrut.equalsIgnoreCase("false")) {
                inputBrut = "Faux";
            }
        }
        String inputFinal = inputBrut;
        String inputNormalise = this.normaliser(inputBrut);
        return switch (1.$SwitchMap$com$moscepa$entity$TypeQuestion[question.getTypeQuestion().ordinal()]) {
            case 1, 2, 3 -> {
                boolean matchId = question.getReponses().stream().filter(Reponse::isCorrecte).anyMatch(r -> r.getId().toString().equals(inputFinal));
                if (matchId) {
                    yield true;
                }
                boolean matchTexte = question.getReponses().stream().filter(Reponse::isCorrecte).anyMatch(r -> this.normaliser(r.getTexte()).equals(inputNormalise));
                if (matchTexte) {
                    yield true;
                }
                if (question.getReponseCorrecteTexte() != null && this.normaliser(question.getReponseCorrecteTexte()).equals(inputNormalise)) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                if (!(reponseDonnee instanceof List)) {
                    yield false;
                }
                List liste = (List)reponseDonnee;
                Set soumises = liste.stream().map(Object::toString).map(String::trim).collect(Collectors.toSet());
                Set correctes = question.getReponses().stream().filter(Reponse::isCorrecte).map(r -> r.getId().toString()).collect(Collectors.toSet());
                if (!correctes.isEmpty() && soumises.equals(correctes)) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public List<QuestionDiagnosticDto> genererTestDiagnosticPourMatiere(Long matiereId) {
        List toutesLesQuestions = this.questionRepository.findQuestionsByMatiereId(matiereId);
        return toutesLesQuestions.stream().limit(20L).map(q -> {
            QuestionDiagnosticDto dto = new QuestionDiagnosticDto();
            dto.setId(q.getId());
            dto.setEnonce(q.getEnonce());
            dto.setTypeQuestion(q.getTypeQuestion());
            if (q.getChapitre() != null) {
                dto.setChapitreId(q.getChapitre().getId());
            }
            List options = q.getReponses().stream().map(ReponsePourQuestionDto::new).collect(Collectors.toList());
            dto.setOptions(options);
            return dto;
        }).collect(Collectors.toList());
    }

    @Transactional
    public ResultatDiagnosticDto corrigerTestDiagnostic(SoumissionTestDto soumission) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth == null || !(auth.getPrincipal() instanceof UserPrincipal)) {
            throw new EntityNotFoundException("Utilisateur non authentifi\u00e9.");
        }
        UserPrincipal principal = (UserPrincipal)auth.getPrincipal();
        Utilisateur etudiant = (Utilisateur)this.utilisateurRepository.findById((Object)principal.getId()).orElseThrow(() -> new EntityNotFoundException("Utilisateur non trouv\u00e9."));
        List ids = soumission.getReponses().stream().map(ReponseSoumiseDto::getQuestionId).collect(Collectors.toList());
        Map<Long, Question> questionsMap = this.questionRepository.findAllWithReponsesByIds(ids).stream().collect(Collectors.toMap(Question::getId, q -> q));
        int totalBonnesReponses = 0;
        HashMap<Chapitre, List> resultatsParChapitre = new HashMap<Chapitre, List>();
        for (ReponseSoumiseDto rep : soumission.getReponses()) {
            Question q2 = questionsMap.get(rep.getQuestionId());
            if (q2 == null) continue;
            boolean correct = this.verifierReponse(q2, rep.getReponse());
            if (correct) {
                ++totalBonnesReponses;
            }
            if (q2.getChapitre() == null) continue;
            resultatsParChapitre.computeIfAbsent(q2.getChapitre(), k -> new ArrayList()).add(correct);
        }
        ResultatDiagnosticDto dto = new ResultatDiagnosticDto();
        int nbQuestionsMap = questionsMap.size();
        dto.setTotalQuestions(nbQuestionsMap);
        dto.setBonnesReponses(totalBonnesReponses);
        dto.setScoreGlobal(nbQuestionsMap > 0 ? (double)totalBonnesReponses * 100.0 / (double)nbQuestionsMap : 0.0);
        HashMap<String, Double> scoreParChapitre = new HashMap<String, Double>();
        ArrayList<ChapitreRecommandationDto> chapitresAReviser = new ArrayList<ChapitreRecommandationDto>();
        for (Map.Entry entry : resultatsParChapitre.entrySet()) {
            Chapitre chapitre = (Chapitre)entry.getKey();
            List resultats = (List)entry.getValue();
            long bonnes = resultats.stream().filter(b -> b).count();
            double score = (double)bonnes * 100.0 / (double)resultats.size();
            scoreParChapitre.put(chapitre.getNom(), score);
            if (!(score < 50.0)) continue;
            chapitresAReviser.add(new ChapitreRecommandationDto(chapitre.getId(), chapitre.getNom(), score));
        }
        dto.setScoreParChapitre(scoreParChapitre);
        dto.setChapitresAReviser(chapitresAReviser);
        dto.setMessage("Analyse de votre niveau termin\u00e9e !");
        return dto;
    }

    public Test save(Test test) {
        return (Test)this.testRepository.save((Object)test);
    }

    public Test update(Long testId, Test testData) {
        Test existing = (Test)this.testRepository.findById((Object)testId).orElseThrow(() -> new EntityNotFoundException("Test non trouv\u00e9 avec l'ID: " + testId));
        existing.setTitre(testData.getTitre());
        existing.setDuree(testData.getDuree());
        existing.setDescription(testData.getDescription());
        return (Test)this.testRepository.save((Object)existing);
    }

    public void deleteById(Long testId) {
        if (!this.testRepository.existsById((Object)testId)) {
            throw new EntityNotFoundException("Test non trouv\u00e9 avec l'ID: " + testId);
        }
        this.testRepository.deleteById((Object)testId);
    }

    @Transactional
    public Test assignerQuestionnaireAuTest(Long chapitreId, Long questionnaireId) {
        Chapitre chapitre = (Chapitre)this.chapitreRepository.findById((Object)chapitreId).orElseThrow(() -> new EntityNotFoundException("Chapitre non trouv\u00e9"));
        Questionnaire questionnaire = (Questionnaire)this.questionnaireRepository.findById((Object)questionnaireId).orElseThrow(() -> new EntityNotFoundException("Questionnaire non trouv\u00e9"));
        Test test = this.testRepository.findTopByChapitreId(chapitreId).orElse(new Test());
        test.setTitre("Test : " + questionnaire.getTitre());
        test.setChapitre(chapitre);
        test.setQuestionnaire(questionnaire);
        test.setQuestions(new ArrayList(questionnaire.getQuestions()));
        return (Test)this.testRepository.save((Object)test);
    }

    public ResultatTestDto calculerResultatEntrainement(Long questionnaireId, Map<String, Object> reponsesUtilisateur) {
        Questionnaire questionnaire = (Questionnaire)this.questionnaireRepository.findById((Object)questionnaireId).orElseThrow(() -> new EntityNotFoundException("Questionnaire non trouv\u00e9 ID: " + questionnaireId));
        double scoreObtenu = 0.0;
        double totalPoints = 0.0;
        int bonnesReponses = 0;
        for (Question question : questionnaire.getQuestions()) {
            totalPoints += question.getPoints();
            Object reponse = reponsesUtilisateur.get(String.valueOf(question.getId()));
            if (!this.verifierReponse(question, reponse)) continue;
            scoreObtenu += question.getPoints();
            ++bonnesReponses;
        }
        ResultatTestDto dto = new ResultatTestDto();
        dto.setScoreObtenu(scoreObtenu);
        dto.setTotalPointsPossible(totalPoints);
        dto.setDateSoumission(LocalDateTime.now());
        return dto;
    }
}

