/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.service;

import com.moscepa.dto.CourseProgressDto;
import com.moscepa.dto.StudentJourneyDto;
import com.moscepa.dto.StudentJourneyFrontDto;
import com.moscepa.entity.Chapitre;
import com.moscepa.entity.ResultatTest;
import com.moscepa.entity.Role;
import com.moscepa.entity.Utilisateur;
import com.moscepa.repository.ResultatTestRepository;
import com.moscepa.repository.UtilisateurRepository;
import com.moscepa.service.FrontendMapperService;
import jakarta.persistence.EntityNotFoundException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class StudentJourneyService {
    private final UtilisateurRepository utilisateurRepository;
    private final ResultatTestRepository resultatTestRepository;
    private final FrontendMapperService mapperService;

    public StudentJourneyService(UtilisateurRepository utilisateurRepository, ResultatTestRepository resultatTestRepository, FrontendMapperService mapperService) {
        this.utilisateurRepository = utilisateurRepository;
        this.resultatTestRepository = resultatTestRepository;
        this.mapperService = mapperService;
    }

    @Transactional
    public void definirTypeParcours(Long etudiantId, String nouveauType) {
        Utilisateur etudiant = (Utilisateur)this.utilisateurRepository.findById((Object)etudiantId).orElseThrow(() -> new EntityNotFoundException("\u00c9tudiant non trouv\u00e9"));
        etudiant.setParcoursType(nouveauType);
        this.utilisateurRepository.save((Object)etudiant);
    }

    public StudentJourneyDto getStudentJourney(Long etudiantId) {
        Utilisateur etudiant = (Utilisateur)this.utilisateurRepository.findById((Object)etudiantId).orElseThrow(() -> new EntityNotFoundException("\u00c9tudiant non trouv\u00e9"));
        List allResults = this.resultatTestRepository.findFullResultsByEtudiant(etudiantId);
        StudentJourneyDto journey = new StudentJourneyDto();
        journey.setStudentId(etudiant.getId());
        journey.setNomComplet(etudiant.getPrenom() + " " + etudiant.getNom());
        journey.setParcoursType(etudiant.getParcoursType() != null ? etudiant.getParcoursType() : "NON DEFINI");
        Map<Long, List<ResultatTest>> resultsByChapitre = allResults.stream().collect(Collectors.groupingBy(r -> r.getTest().getChapitre().getId()));
        List progression = resultsByChapitre.entrySet().stream().map(entry -> {
            List tests = (List)entry.getValue();
            Chapitre chapitre = ((ResultatTest)tests.get(0)).getTest().getChapitre();
            List notes = tests.stream().map(ResultatTest::getScore).collect(Collectors.toList());
            CourseProgressDto dto = new CourseProgressDto();
            dto.setCourseId(chapitre.getId());
            dto.setCourseName(chapitre.getNom());
            dto.setNotesDetaillees(notes);
            dto.setTestsPasses(tests.size());
            double derniereNote = (Double)notes.get(0);
            if (derniereNote < 33.0) {
                dto.setStatutRecommandation("Faible");
            } else if (derniereNote < 66.0) {
                dto.setStatutRecommandation("Moyen");
            } else {
                dto.setStatutRecommandation("Bonne ma\u00eetrise");
            }
            return dto;
        }).collect(Collectors.toList());
        journey.setProgressionParCours(progression);
        return journey;
    }

    public List<StudentJourneyDto> getAllJourneys(String type) {
        List etudiants = this.utilisateurRepository.findByRole(Role.ETUDIANT);
        return etudiants.stream().map(etudiant -> this.getStudentJourney(etudiant.getId())).filter(dto -> {
            if (type == null || type.isEmpty() || type.equalsIgnoreCase("ALL")) {
                return true;
            }
            return dto.getParcoursType().equalsIgnoreCase(type);
        }).collect(Collectors.toList());
    }

    public StudentJourneyFrontDto getStudentJourneyForFrontend(Long etudiantId) {
        return this.mapperService.toFrontDto(this.getStudentJourney(etudiantId));
    }

    public List<StudentJourneyFrontDto> getAllJourneysForFrontend(String type) {
        return this.mapperService.toFrontDtoList(this.getAllJourneys(type));
    }

    public List<StudentJourneyDto> getStudentsForTeacher(Long teacherId) {
        Utilisateur enseignant = (Utilisateur)this.utilisateurRepository.findById((Object)teacherId).orElseThrow(() -> new EntityNotFoundException("Enseignant non trouv\u00e9."));
        List formations = enseignant.getFormationsCrees();
        List etudiants = formations.stream().flatMap(f -> this.utilisateurRepository.findAllByFormationActuelle(f.getNom()).stream().filter(u -> u.getRoles().stream().anyMatch(r -> r.equals("ETUDIANT")))).distinct().collect(Collectors.toList());
        return etudiants.stream().map(etudiant -> this.getStudentJourney(etudiant.getId())).collect(Collectors.toList());
    }

    public List<StudentJourneyFrontDto> getStudentsForTeacherForFrontend(Long teacherId) {
        List backendList = this.getStudentsForTeacher(teacherId);
        return this.mapperService.toFrontDtoList(backendList);
    }
}

