/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.moscepa.dto.RessourceTeleversementDto;
import com.moscepa.entity.Chapitre;
import com.moscepa.entity.RessourcePedagogique;
import com.moscepa.entity.Tag;
import com.moscepa.entity.Utilisateur;
import com.moscepa.repository.ChapitreRepository;
import com.moscepa.repository.RessourcePedagogiqueRepository;
import com.moscepa.repository.TagRepository;
import com.moscepa.repository.UtilisateurRepository;
import com.moscepa.security.UserPrincipal;
import jakarta.persistence.EntityNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(readOnly=true)
public class RessourcePedagogiqueService {
    private final String storageLocation;
    private final RessourcePedagogiqueRepository ressourceRepository;
    private final ChapitreRepository chapitreRepository;
    private final UtilisateurRepository utilisateurRepository;
    private final TagRepository tagRepository;
    private final ObjectMapper objectMapper;

    public RessourcePedagogiqueService(RessourcePedagogiqueRepository ressourceRepository, ChapitreRepository chapitreRepository, UtilisateurRepository utilisateurRepository, TagRepository tagRepository, ObjectMapper objectMapper, @Value(value="${file.upload-dir}") String storageLocation) {
        this.ressourceRepository = ressourceRepository;
        this.chapitreRepository = chapitreRepository;
        this.utilisateurRepository = utilisateurRepository;
        this.tagRepository = tagRepository;
        this.objectMapper = objectMapper;
        this.storageLocation = storageLocation;
        this.initialiserDossierStockage();
    }

    private void initialiserDossierStockage() {
        try {
            if (this.storageLocation == null || this.storageLocation.trim().isEmpty()) {
                throw new IllegalStateException("La propri\u00e9t\u00e9 'file.upload-dir' n'a pas \u00e9t\u00e9 inject\u00e9e ou est vide.");
            }
            Files.createDirectories(Paths.get(this.storageLocation, new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Impossible d'initialiser le dossier de stockage: " + this.storageLocation, e);
        }
    }

    @Transactional
    public RessourcePedagogique televerserEtSauvegarder(MultipartFile fichier, String metadataJson) throws IOException {
        RessourceTeleversementDto metadata = (RessourceTeleversementDto)this.objectMapper.readValue(metadataJson, RessourceTeleversementDto.class);
        String nomUnique = UUID.randomUUID().toString() + "_" + fichier.getOriginalFilename();
        Path destinationFile = Paths.get(this.storageLocation, new String[0]).resolve(nomUnique);
        Files.copy(fichier.getInputStream(), destinationFile, StandardCopyOption.REPLACE_EXISTING);
        RessourcePedagogique ressource = new RessourcePedagogique();
        UserPrincipal userPrincipal = (UserPrincipal)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        Utilisateur auteur = (Utilisateur)this.utilisateurRepository.findById((Object)userPrincipal.getId()).orElseThrow(() -> new EntityNotFoundException("Auteur non trouv\u00e9."));
        Chapitre chapitre = (Chapitre)this.chapitreRepository.findById((Object)metadata.getChapitreId()).orElseThrow(() -> new EntityNotFoundException("Chapitre non trouv\u00e9."));
        Set tags = metadata.getTags().stream().map(nom -> this.tagRepository.findByNomIgnoreCase(nom).orElseGet(() -> (Tag)this.tagRepository.save((Object)new Tag(nom)))).collect(Collectors.toSet());
        ressource.setTitre(metadata.getTitre());
        ressource.setDescription(metadata.getDescription());
        ressource.setNomFichier(fichier.getOriginalFilename());
        ressource.setCheminStockage(nomUnique);
        ressource.setTypeMime(fichier.getContentType());
        ressource.setTailleOctets(Long.valueOf(fichier.getSize()));
        ressource.setAuteur(auteur);
        ressource.setChapitre(chapitre);
        ressource.setTags(tags);
        return (RessourcePedagogique)this.ressourceRepository.save((Object)ressource);
    }

    public List<RessourcePedagogique> findAll() {
        return this.ressourceRepository.findAll();
    }

    public Resource chargerFichierCommeRessource(String nomFichierStocke) {
        try {
            Path file = Paths.get(this.storageLocation, new String[0]).resolve(nomFichierStocke);
            UrlResource resource = new UrlResource(file.toUri());
            if (resource.exists() || resource.isReadable()) {
                return resource;
            }
            throw new RuntimeException("Impossible de lire le fichier: " + nomFichierStocke);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Erreur de chemin de fichier: " + nomFichierStocke, e);
        }
    }

    @Transactional
    public void supprimerRessource(Long id) {
        RessourcePedagogique ressource = (RessourcePedagogique)this.ressourceRepository.findById((Object)id).orElseThrow(() -> new EntityNotFoundException("Ressource non trouv\u00e9e avec l'ID: " + id));
        try {
            Path fileToDelete = Paths.get(this.storageLocation, new String[0]).resolve(ressource.getCheminStockage());
            Files.deleteIfExists(fileToDelete);
        }
        catch (IOException e) {
            System.err.println("Erreur lors de la suppression physique du fichier: " + e.getMessage());
        }
        this.ressourceRepository.delete((Object)ressource);
    }
}

