/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.service;

import com.moscepa.dto.QuestionDto;
import com.moscepa.dto.ReponsePourQuestionDto;
import com.moscepa.entity.Question;
import com.moscepa.entity.Questionnaire;
import com.moscepa.entity.Reponse;
import com.moscepa.repository.QuestionRepository;
import com.moscepa.repository.QuestionnaireRepository;
import com.moscepa.repository.TestRepository;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.PersistenceContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class QuestionService {
    private final QuestionRepository questionRepository;
    private final QuestionnaireRepository questionnaireRepository;
    private final TestRepository testRepository;
    @PersistenceContext
    private EntityManager entityManager;

    public QuestionService(QuestionRepository questionRepository, QuestionnaireRepository questionnaireRepository, TestRepository testRepository) {
        this.questionRepository = questionRepository;
        this.questionnaireRepository = questionnaireRepository;
        this.testRepository = testRepository;
    }

    @Transactional
    public Question createQuestion(QuestionDto questionDto, Long questionnaireId) {
        Questionnaire questionnaire = (Questionnaire)this.questionnaireRepository.findById((Object)questionnaireId).orElseThrow(() -> new EntityNotFoundException("Questionnaire non trouv\u00e9 avec l'ID : " + questionnaireId));
        Question question = new Question();
        question.setEnonce(questionDto.getEnonce());
        question.setPoints(questionDto.getPoints());
        question.setTypeQuestion(questionDto.getType());
        question.setQuestionnaire(questionnaire);
        if (questionDto.getReponses() != null && !questionDto.getReponses().isEmpty()) {
            for (ReponsePourQuestionDto reponseDto : questionDto.getReponses()) {
                Reponse nouvelleReponse = new Reponse();
                nouvelleReponse.setTexte(reponseDto.getTexte());
                nouvelleReponse.setCorrecte(reponseDto.isCorrecte());
                question.addReponse(nouvelleReponse);
            }
        }
        return (Question)this.questionRepository.save((Object)question);
    }

    public QuestionDto getQuestionById(Long id) {
        Question question = (Question)this.questionRepository.findById((Object)id).orElseThrow(() -> new EntityNotFoundException("Question non trouv\u00e9e avec l'ID : " + id));
        return new QuestionDto(question);
    }

    public List<QuestionDto> getAllQuestions() {
        return this.questionRepository.findAll().stream().map(QuestionDto::new).collect(Collectors.toList());
    }

    @Transactional
    public Question updateQuestion(Long id, QuestionDto questionDto) {
        Question question = (Question)this.questionRepository.findById((Object)id).orElseThrow(() -> new EntityNotFoundException("Question non trouv\u00e9e avec l'ID : " + id));
        question.setEnonce(questionDto.getEnonce());
        question.setPoints(questionDto.getPoints());
        question.setTypeQuestion(questionDto.getType());
        if (questionDto.getReponses() != null) {
            question.getReponses().clear();
            for (ReponsePourQuestionDto reponseDto : questionDto.getReponses()) {
                Reponse reponse = new Reponse();
                reponse.setTexte(reponseDto.getTexte());
                reponse.setCorrecte(reponseDto.isCorrecte());
                question.addReponse(reponse);
            }
        }
        return (Question)this.questionRepository.save((Object)question);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Transactional
    public ResponseEntity<Map<String, Object>> deleteQuestionFinal(Long questionId) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            System.out.println("D\u00e9but suppression - Question ID: " + questionId);
            if (!this.questionRepository.existsById((Object)questionId)) {
                response.put("success", false);
                response.put("message", "Question non trouv\u00e9e avec l'ID : " + questionId);
                return new ResponseEntity(response, (HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            this.entityManager.createNativeQuery("SET FOREIGN_KEY_CHECKS = 0").executeUpdate();
            System.out.println("FOREIGN_KEY_CHECKS d\u00e9sactiv\u00e9s");
            try {
                int testRelationsDeleted = this.entityManager.createNativeQuery("DELETE FROM moscepa_test_questions WHERE question_id = :id").setParameter("id", (Object)questionId).executeUpdate();
                System.out.println("Relations test supprim\u00e9es: " + testRelationsDeleted);
                int reponsesDeleted = this.entityManager.createNativeQuery("DELETE FROM moscepa_reponses WHERE question_id = :id").setParameter("id", (Object)questionId).executeUpdate();
                System.out.println("R\u00e9ponses supprim\u00e9es: " + reponsesDeleted);
                int questionDeleted = this.entityManager.createNativeQuery("DELETE FROM moscepa_questions WHERE id = :id").setParameter("id", (Object)questionId).executeUpdate();
                System.out.println("Question supprim\u00e9e: " + questionDeleted);
                if (questionDeleted > 0) {
                    response.put("success", true);
                    response.put("message", "Question supprim\u00e9e avec succ\u00e8s");
                    response.put("deletedRelations", testRelationsDeleted);
                    response.put("deletedReponses", reponsesDeleted);
                    response.put("questionId", questionId);
                    ResponseEntity responseEntity = new ResponseEntity(response, (HttpStatusCode)HttpStatus.OK);
                    return responseEntity;
                }
                response.put("success", false);
                response.put("message", "\u00c9chec de la suppression de la question");
                ResponseEntity responseEntity = new ResponseEntity(response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                return responseEntity;
            }
            finally {
                this.entityManager.createNativeQuery("SET FOREIGN_KEY_CHECKS = 1").executeUpdate();
                System.out.println("FOREIGN_KEY_CHECKS r\u00e9activ\u00e9s");
            }
        }
        catch (Exception e) {
            System.err.println("ERREUR lors de la suppression: " + e.getMessage());
            e.printStackTrace();
            try {
                this.entityManager.createNativeQuery("SET FOREIGN_KEY_CHECKS = 1").executeUpdate();
            }
            catch (Exception exception) {
                // empty catch block
            }
            response.put("success", false);
            response.put("message", "Erreur lors de la suppression: " + e.getMessage());
            response.put("error", e.getClass().getSimpleName());
            return new ResponseEntity(response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @Transactional
    public boolean deleteQuestionAlternative(Long questionId) {
        try {
            String sql = "SET FOREIGN_KEY_CHECKS = 0; DELETE FROM moscepa_test_questions WHERE question_id = ?; DELETE FROM moscepa_reponses WHERE question_id = ?; DELETE FROM moscepa_questions WHERE id = ?; SET FOREIGN_KEY_CHECKS = 1";
            this.entityManager.createNativeQuery(sql).setParameter(1, (Object)questionId).setParameter(2, (Object)questionId).setParameter(3, (Object)questionId).executeUpdate();
            return true;
        }
        catch (Exception e) {
            System.err.println("Erreur alternative: " + e.getMessage());
            return false;
        }
    }

    public List<QuestionDto> getQuestionsByQuestionnaireId(Long questionnaireId) {
        List questions = this.questionRepository.findByQuestionnaire_Id(questionnaireId);
        return questions.stream().map(QuestionDto::new).collect(Collectors.toList());
    }

    public Question getQuestionWithRelations(Long id) {
        return (Question)this.questionRepository.findById((Object)id).orElseThrow(() -> new EntityNotFoundException("Question non trouv\u00e9e avec l'ID : " + id));
    }

    public List<QuestionDto> getQuestionsByChapitreId(Long chapitreId) {
        List questions = this.questionRepository.findByChapitreId(chapitreId);
        return questions.stream().map(QuestionDto::new).collect(Collectors.toList());
    }

    public List<QuestionDto> getQuestionsByMatiereId(Long matiereId) {
        List questions = this.questionRepository.findQuestionsByMatiereId(matiereId);
        return questions.stream().map(QuestionDto::new).collect(Collectors.toList());
    }

    public List<QuestionDto> getBanqueQuestionsByChapitreId(Long chapitreId) {
        List questions = this.questionRepository.findBanqueQuestionsByChapitreId(chapitreId);
        return questions.stream().map(QuestionDto::new).collect(Collectors.toList());
    }

    public List<QuestionDto> getQuestionsByQuestionnaireChapitreId(Long chapitreId) {
        List questions = this.questionRepository.findByQuestionnaireChapitreId(chapitreId);
        return questions.stream().map(QuestionDto::new).collect(Collectors.toList());
    }

    public boolean questionExists(Long questionId) {
        return this.questionRepository.existsById((Object)questionId);
    }

    public boolean canDeleteQuestion(Long questionId) {
        try {
            String checkSQL = "SELECT COUNT(*) FROM moscepa_test_questions WHERE question_id = ?";
            Long count = ((Number)this.entityManager.createNativeQuery(checkSQL).setParameter(1, (Object)questionId).getSingleResult()).longValue();
            return count == 0L;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Map<String, Object> getQuestionStats(Long questionId) {
        HashMap<String, Object> stats = new HashMap<String, Object>();
        try {
            boolean exists = this.questionRepository.existsById((Object)questionId);
            stats.put("exists", exists);
            if (!exists) {
                stats.put("message", "Question non trouv\u00e9e");
                return stats;
            }
            Long testCount = ((Number)this.entityManager.createNativeQuery("SELECT COUNT(*) FROM moscepa_test_questions WHERE question_id = ?").setParameter(1, (Object)questionId).getSingleResult()).longValue();
            stats.put("usedInTests", testCount);
            Long reponseCount = ((Number)this.entityManager.createNativeQuery("SELECT COUNT(*) FROM moscepa_reponses WHERE question_id = ?").setParameter(1, (Object)questionId).getSingleResult()).longValue();
            stats.put("reponseCount", reponseCount);
            stats.put("canDelete", testCount == 0L);
        }
        catch (Exception e) {
            stats.put("error", e.getMessage());
        }
        return stats;
    }

    @Transactional
    public Question duplicateQuestion(Long questionId) {
        Question original = (Question)this.questionRepository.findById((Object)questionId).orElseThrow(() -> new EntityNotFoundException("Question non trouv\u00e9e"));
        Question duplicate = new Question();
        duplicate.setEnonce("[COPIE] " + original.getEnonce());
        duplicate.setPoints(original.getPoints());
        duplicate.setTypeQuestion(original.getTypeQuestion());
        duplicate.setQuestionnaire(original.getQuestionnaire());
        duplicate.setChapitre(original.getChapitre());
        if (original.getReponses() != null) {
            for (Reponse reponse : original.getReponses()) {
                Reponse reponseDupliquee = new Reponse();
                reponseDupliquee.setTexte(reponse.getTexte());
                reponseDupliquee.setCorrecte(reponse.isCorrecte());
                duplicate.addReponse(reponseDupliquee);
            }
        }
        return (Question)this.questionRepository.save((Object)duplicate);
    }

    @Transactional
    public Question changeQuestionnaire(Long questionId, Long newQuestionnaireId) {
        Question question = (Question)this.questionRepository.findById((Object)questionId).orElseThrow(() -> new EntityNotFoundException("Question non trouv\u00e9e"));
        Questionnaire newQuestionnaire = (Questionnaire)this.questionnaireRepository.findById((Object)newQuestionnaireId).orElseThrow(() -> new EntityNotFoundException("Questionnaire non trouv\u00e9"));
        if (question.getQuestionnaire() != null) {
            Questionnaire oldQuestionnaire = question.getQuestionnaire();
            oldQuestionnaire.getQuestions().remove(question);
            this.questionnaireRepository.save((Object)oldQuestionnaire);
        }
        question.setQuestionnaire(newQuestionnaire);
        newQuestionnaire.getQuestions().add(question);
        return (Question)this.questionRepository.save((Object)question);
    }

    public long countAllQuestions() {
        return this.questionRepository.count();
    }

    public long countQuestionsInQuestionnaire(Long questionnaireId) {
        return this.questionRepository.findByQuestionnaire_Id(questionnaireId).size();
    }

    public long countQuestionsInChapitre(Long chapitreId) {
        return this.questionRepository.findByChapitreId(chapitreId).size();
    }

    public List<QuestionDto> searchQuestions(String searchTerm) {
        return this.questionRepository.findAll().stream().filter(q -> q.getEnonce().toLowerCase().contains(searchTerm.toLowerCase())).map(QuestionDto::new).collect(Collectors.toList());
    }

    public List<QuestionDto> getQuestionsByType(String typeQuestion) {
        return this.questionRepository.findAll().stream().filter(q -> q.getTypeQuestion() != null && q.getTypeQuestion().name().equals(typeQuestion)).map(QuestionDto::new).collect(Collectors.toList());
    }

    public List<QuestionDto> getQuestionsWithMinPoints(double minPoints) {
        return this.questionRepository.findAll().stream().filter(q -> q.getPoints() >= minPoints).map(QuestionDto::new).collect(Collectors.toList());
    }
}

