/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.service;

import com.moscepa.dto.ParcoursDto;
import com.moscepa.dto.ParcoursItemDto;
import com.moscepa.entity.Chapitre;
import com.moscepa.entity.Parcours;
import com.moscepa.entity.ResultatTest;
import com.moscepa.entity.Utilisateur;
import com.moscepa.repository.ChapitreRepository;
import com.moscepa.repository.ParcoursRepository;
import com.moscepa.repository.ResultatTestRepository;
import com.moscepa.repository.UtilisateurRepository;
import jakarta.persistence.EntityNotFoundException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ParcoursService {
    private final ParcoursRepository parcoursRepository;
    private final UtilisateurRepository utilisateurRepository;
    private final ChapitreRepository chapitreRepository;
    private final ResultatTestRepository resultatTestRepository;

    public ParcoursService(ParcoursRepository parcoursRepository, UtilisateurRepository utilisateurRepository, ChapitreRepository chapitreRepository, ResultatTestRepository resultatTestRepository) {
        this.parcoursRepository = parcoursRepository;
        this.utilisateurRepository = utilisateurRepository;
        this.chapitreRepository = chapitreRepository;
        this.resultatTestRepository = resultatTestRepository;
    }

    public ParcoursDto getParcoursPourEtudiant(Long utilisateurId) {
        if (!this.utilisateurRepository.existsById((Object)utilisateurId)) {
            throw new EntityNotFoundException("Aucun \u00e9tudiant trouv\u00e9 pour l'utilisateur ID: " + utilisateurId);
        }
        List parcoursList = this.parcoursRepository.findByUtilisateurIdOrderByDateAjoutDesc(utilisateurId);
        ArrayList<ParcoursItemDto> recommandes = new ArrayList<ParcoursItemDto>();
        ArrayList<ParcoursItemDto> choisis = new ArrayList<ParcoursItemDto>();
        for (Parcours parcours : parcoursList) {
            ResultatTest dernierResultat;
            List resultats = this.resultatTestRepository.findLatestByEtudiantAndChapitre(utilisateurId, parcours.getChapitre().getId());
            double scoreEnPourcentage = 0.0;
            if (!resultats.isEmpty() && (dernierResultat = (ResultatTest)resultats.get(0)).getScoreTotal() != null && dernierResultat.getScoreTotal() > 0.0) {
                scoreEnPourcentage = dernierResultat.getScore() / dernierResultat.getScoreTotal() * 100.0;
            }
            ParcoursItemDto dto = new ParcoursItemDto(parcours.getChapitre().getId(), parcours.getChapitre().getNom(), parcours.getChapitre().getElementConstitutif().getNom(), scoreEnPourcentage);
            if (parcours.getType() == Parcours.TypeParcours.RECOMMANDE) {
                recommandes.add(dto);
            }
            if (parcours.getType() != Parcours.TypeParcours.CHOISI) continue;
            choisis.add(dto);
        }
        List mixtes = Stream.concat(recommandes.stream(), choisis.stream()).distinct().collect(Collectors.toList());
        ParcoursDto resultatDto = new ParcoursDto();
        resultatDto.setRecommandes(recommandes);
        resultatDto.setChoisis(choisis);
        resultatDto.setMixtes(mixtes);
        return resultatDto;
    }

    @Transactional
    public void enregistrerChoixEtudiant(Long utilisateurId, List<Long> chapitreIds) {
        if (chapitreIds == null || chapitreIds.isEmpty()) {
            return;
        }
        Utilisateur etudiant = (Utilisateur)this.utilisateurRepository.findById((Object)utilisateurId).orElseThrow(() -> new EntityNotFoundException("Utilisateur non trouv\u00e9 avec l'ID: " + utilisateurId));
        List chapitres = this.chapitreRepository.findAllById(chapitreIds);
        for (Chapitre chapitre : chapitres) {
            boolean existeDeja = this.parcoursRepository.existsByUtilisateurIdAndChapitreIdAndType(utilisateurId, chapitre.getId(), Parcours.TypeParcours.CHOISI);
            if (existeDeja) continue;
            Parcours nouveauParcours = new Parcours();
            nouveauParcours.setUtilisateur(etudiant);
            nouveauParcours.setChapitre(chapitre);
            nouveauParcours.setType(Parcours.TypeParcours.CHOISI);
            nouveauParcours.setDateAjout(LocalDateTime.now());
            this.parcoursRepository.save((Object)nouveauParcours);
        }
    }

    @Transactional
    public void enregistrerParcoursRecommande(Long utilisateurId, List<Long> chapitreIds) {
        if (chapitreIds == null || chapitreIds.isEmpty()) {
            return;
        }
        Utilisateur etudiant = (Utilisateur)this.utilisateurRepository.findById((Object)utilisateurId).orElseThrow(() -> new EntityNotFoundException("Utilisateur non trouv\u00e9 avec l'ID: " + utilisateurId));
        List chapitres = this.chapitreRepository.findAllById(chapitreIds);
        for (Chapitre chapitre : chapitres) {
            boolean existeDeja = this.parcoursRepository.existsByUtilisateurIdAndChapitreIdAndType(utilisateurId, chapitre.getId(), Parcours.TypeParcours.RECOMMANDE);
            if (existeDeja) continue;
            Parcours nouveauParcours = new Parcours();
            nouveauParcours.setUtilisateur(etudiant);
            nouveauParcours.setChapitre(chapitre);
            nouveauParcours.setType(Parcours.TypeParcours.RECOMMANDE);
            nouveauParcours.setDateAjout(LocalDateTime.now());
            this.parcoursRepository.save((Object)nouveauParcours);
        }
    }
}

