/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.service;

import com.moscepa.dto.MatiereDto;
import com.moscepa.entity.Matiere;
import com.moscepa.repository.MatiereRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MatiereService {
    @Autowired
    private MatiereRepository matiereRepository;

    @Transactional(readOnly=true)
    public List<MatiereDto> getMatieres() {
        return this.matiereRepository.findAllOrderByNom().stream().map(arg_0 -> this.convertToDto(arg_0)).collect(Collectors.toList());
    }

    @Transactional(readOnly=true)
    public Optional<MatiereDto> getMatiereById(Long id) {
        return this.matiereRepository.findById((Object)id).map(arg_0 -> this.convertToDto(arg_0));
    }

    @Transactional(readOnly=true)
    public List<String> getMatieresDisponibles() {
        return this.matiereRepository.findAllNoms();
    }

    public MatiereDto createMatiere(MatiereDto matiereDto) {
        if (this.matiereRepository.existsByNom(matiereDto.getNom())) {
            throw new RuntimeException("Une mati\u00e8re avec ce nom existe d\u00e9j\u00e0");
        }
        Matiere matiere = new Matiere();
        matiere.setNom(matiereDto.getNom());
        matiere.setDescription(matiereDto.getDescription());
        matiere = (Matiere)this.matiereRepository.save((Object)matiere);
        return this.convertToDto(matiere);
    }

    public MatiereDto updateMatiere(Long id, MatiereDto matiereDto) {
        Matiere matiere = (Matiere)this.matiereRepository.findById((Object)id).orElseThrow(() -> new RuntimeException("Mati\u00e8re non trouv\u00e9e avec l'ID: " + id));
        if (!matiere.getNom().equals(matiereDto.getNom()) && this.matiereRepository.existsByNom(matiereDto.getNom())) {
            throw new RuntimeException("Une mati\u00e8re avec ce nom existe d\u00e9j\u00e0");
        }
        matiere.setNom(matiereDto.getNom());
        matiere.setDescription(matiereDto.getDescription());
        matiere = (Matiere)this.matiereRepository.save((Object)matiere);
        return this.convertToDto(matiere);
    }

    public void deleteMatiere(Long id) {
        if (!this.matiereRepository.existsById((Object)id)) {
            throw new RuntimeException("Mati\u00e8re non trouv\u00e9e avec l'ID: " + id);
        }
        this.matiereRepository.deleteById((Object)id);
    }

    @Transactional(readOnly=true)
    public List<MatiereDto> searchMatieres(String nom) {
        return this.matiereRepository.findByNomContainingIgnoreCase(nom).stream().map(arg_0 -> this.convertToDto(arg_0)).collect(Collectors.toList());
    }

    private MatiereDto convertToDto(Matiere matiere) {
        MatiereDto dto = new MatiereDto();
        dto.setId(matiere.getId());
        dto.setNom(matiere.getNom());
        dto.setDescription(matiere.getDescription());
        return dto;
    }

    @Transactional(readOnly=true)
    public List<MatiereDto> getMatieresAvecDetails() {
        List matieres = this.matiereRepository.findAll();
        return matieres.stream().map(arg_0 -> this.convertirMatiereEnDtoAvecChapitres(arg_0)).collect(Collectors.toList());
    }

    private MatiereDto convertirMatiereEnDtoAvecChapitres(Matiere matiere) {
        MatiereDto matiereDto = this.convertToDto(matiere);
        matiereDto.setChapitres(new ArrayList());
        return matiereDto;
    }
}

