/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.service;

import com.moscepa.dto.FonctionnaliteDTO;
import com.moscepa.entity.Fonctionnalite;
import com.moscepa.entity.SousFonctionnalite;
import com.moscepa.repository.FonctionnaliteRepository;
import jakarta.persistence.EntityNotFoundException;
import java.util.List;
import java.util.stream.Collectors;
import org.modelmapper.ModelMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FonctionnaliteService {
    @Autowired
    private FonctionnaliteRepository fonctionnaliteRepository;
    @Autowired
    private ModelMapper modelMapper;

    @Transactional(readOnly=true)
    public List<FonctionnaliteDTO> getAllFonctionnalites() {
        return this.fonctionnaliteRepository.findAll().stream().map(entity -> (FonctionnaliteDTO)this.modelMapper.map(entity, FonctionnaliteDTO.class)).collect(Collectors.toList());
    }

    @Transactional
    public FonctionnaliteDTO createFonctionnalite(FonctionnaliteDTO dto) {
        Fonctionnalite entity = (Fonctionnalite)this.modelMapper.map((Object)dto, Fonctionnalite.class);
        Fonctionnalite savedEntity = (Fonctionnalite)this.fonctionnaliteRepository.save((Object)entity);
        return (FonctionnaliteDTO)this.modelMapper.map((Object)savedEntity, FonctionnaliteDTO.class);
    }

    @Transactional
    public FonctionnaliteDTO updateFonctionnalite(Long id, FonctionnaliteDTO dto) {
        Fonctionnalite existingEntity = (Fonctionnalite)this.fonctionnaliteRepository.findById((Object)id).orElseThrow(() -> new EntityNotFoundException("Fonctionnalit\u00e9 non trouv\u00e9e avec l'id: " + id));
        existingEntity.setNom(dto.getNom());
        existingEntity.setFeatureKey(dto.getFeatureKey());
        existingEntity.setIcon(dto.getIcon());
        existingEntity.getSousFonctionnalites().clear();
        if (dto.getSousFonctionnalites() != null) {
            List updatedSubFeatures = dto.getSousFonctionnalites().stream().map(subDto -> (SousFonctionnalite)this.modelMapper.map(subDto, SousFonctionnalite.class)).collect(Collectors.toList());
            existingEntity.getSousFonctionnalites().addAll(updatedSubFeatures);
        }
        Fonctionnalite savedEntity = (Fonctionnalite)this.fonctionnaliteRepository.save((Object)existingEntity);
        return (FonctionnaliteDTO)this.modelMapper.map((Object)savedEntity, FonctionnaliteDTO.class);
    }

    @Transactional
    public void deleteFonctionnalite(Long id) {
        if (!this.fonctionnaliteRepository.existsById((Object)id)) {
            throw new EntityNotFoundException("Fonctionnalit\u00e9 non trouv\u00e9e avec l'id: " + id);
        }
        this.fonctionnaliteRepository.deleteById((Object)id);
    }
}

