/*
 * Decompiled with CFR 0.152.
 */
package com.moscepa.service;

import com.moscepa.dto.EtudiantRegistrationDto;
import com.moscepa.dto.InscriptionRequestDto;
import com.moscepa.dto.MatiereInscriteDto;
import com.moscepa.entity.ElementConstitutif;
import com.moscepa.entity.Inscription;
import com.moscepa.entity.Role;
import com.moscepa.entity.Utilisateur;
import com.moscepa.repository.InscriptionRepository;
import com.moscepa.repository.UtilisateurRepository;
import com.moscepa.service.InscriptionService;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EtudiantService {
    @Autowired
    private UtilisateurRepository utilisateurRepository;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private InscriptionRepository inscriptionRepository;
    @Autowired
    private InscriptionService inscriptionService;

    @Transactional
    public Utilisateur inscrireEtudiant(EtudiantRegistrationDto dto) {
        if (this.utilisateurRepository.existsByEmail(dto.getEmail())) {
            throw new IllegalStateException("Un utilisateur avec l'email " + dto.getEmail() + " existe d\u00e9j\u00e0.");
        }
        Utilisateur nouvelEtudiant = new Utilisateur();
        nouvelEtudiant.setNom(dto.getNom());
        nouvelEtudiant.setPrenom(dto.getPrenom());
        nouvelEtudiant.setEmail(dto.getEmail());
        nouvelEtudiant.setMotDePasse(this.passwordEncoder.encode((CharSequence)dto.getMotDePasse()));
        nouvelEtudiant.setRole(Role.ETUDIANT);
        nouvelEtudiant.setActif(Boolean.valueOf(true));
        nouvelEtudiant.setDateDeNaissance(dto.getDateDeNaissance());
        nouvelEtudiant.setLieuDeNaissance(dto.getLieuDeNaissance());
        nouvelEtudiant.setNationalite(dto.getNationalite());
        nouvelEtudiant.setSexe(dto.getSexe());
        nouvelEtudiant.setAdresse(dto.getAdresse());
        nouvelEtudiant.setTelephone(dto.getTelephone());
        nouvelEtudiant.setAnneeAcademique(dto.getAnneeAcademique());
        nouvelEtudiant.setFiliere(dto.getFiliere());
        Utilisateur etudiantSauvegarde = (Utilisateur)this.utilisateurRepository.save((Object)nouvelEtudiant);
        if (dto.getMatiereIds() != null && !dto.getMatiereIds().isEmpty()) {
            for (Long matiereId : dto.getMatiereIds()) {
                InscriptionRequestDto inscriptionRequest = new InscriptionRequestDto();
                inscriptionRequest.setEtudiantId(etudiantSauvegarde.getId());
                inscriptionRequest.setEcId(matiereId);
                this.inscriptionService.inscrireEtudiant(inscriptionRequest);
            }
        }
        return etudiantSauvegarde;
    }

    @Transactional(readOnly=true)
    public List<MatiereInscriteDto> getMatieresInscrites(Long utilisateurId) {
        List inscriptionsValides = this.inscriptionRepository.findByEtudiantIdAndStatut(utilisateurId, "VALIDE");
        return inscriptionsValides.stream().map(arg_0 -> this.convertToMatiereInscriteDto(arg_0)).collect(Collectors.toList());
    }

    private MatiereInscriteDto convertToMatiereInscriteDto(Inscription inscription) {
        ElementConstitutif ec = inscription.getMatiere();
        MatiereInscriteDto dto = new MatiereInscriteDto();
        dto.setId(ec.getId());
        dto.setNomEc(ec.getNom());
        dto.setCodeEc(ec.getCode());
        dto.setCoefficient(ec.getCredit().intValue());
        dto.setStatut("VALIDE");
        if (ec.getUniteEnseignement() != null) {
            dto.setNomUe(ec.getUniteEnseignement().getNom());
            dto.setCodeUe(ec.getUniteEnseignement().getCode());
        } else {
            dto.setNomUe("Non applicable");
            dto.setCodeUe("N/A");
        }
        return dto;
    }
}

